/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics.timeline;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggregator;

public class AvgTimelineAggregator
extends TimelineAggregator {
    private long nextIntervalKey = -1L;
    private double sum = 0.0;
    private double count = 0.0;
    private long lastTimestamp = -1L;

    public AvgTimelineAggregator(long interval) {
        super(interval);
    }

    @Override
    public void addValue(Tuple2<Long, Double> value) {
        if (this.lastTimestamp >= (Long)value.f0) {
            return;
        }
        this.lastTimestamp = (Long)value.f0;
        if (this.nextIntervalKey == (Long)value.f0 / this.interval) {
            this.sum += ((Double)value.f1).doubleValue();
            this.count += 1.0;
        } else if (this.nextIntervalKey < (Long)value.f0 / this.interval) {
            if (this.count > 0.0) {
                this.currentTimestamp = this.nextIntervalKey * this.interval;
                this.currentValue = this.sum / this.count;
            }
            this.nextIntervalKey = (Long)value.f0 / this.interval;
            this.sum = (Double)value.f1;
            this.count = 1.0;
        }
    }
}

