/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics.timeline;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggregator;

public class DeltaMinTimelineAggregator
extends TimelineAggregator {
    private long nextIntervalKey = -1L;
    private double min = Double.NEGATIVE_INFINITY;
    private long lastTimestamp = -1L;
    private double lastValue = 0.0;

    public DeltaMinTimelineAggregator(long interval) {
        super(interval);
    }

    @Override
    public void addValue(Tuple2<Long, Double> value) {
        if (this.lastTimestamp >= (Long)value.f0) {
            return;
        }
        double delta = (Double)value.f1 - this.lastValue;
        this.lastValue = (Double)value.f1;
        this.lastTimestamp = (Long)value.f0;
        if (this.nextIntervalKey == (Long)value.f0 / this.interval && this.min > delta) {
            this.min = delta;
        } else if (this.nextIntervalKey < (Long)value.f0 / this.interval) {
            if (this.min != Double.NEGATIVE_INFINITY) {
                this.currentTimestamp = this.nextIntervalKey * this.interval;
                this.currentValue = this.min;
            }
            this.nextIntervalKey = (Long)value.f0 / this.interval;
            this.min = delta;
        }
    }
}

