/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics.timeline;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggregator;

public class EarliestTimelineAggregator
extends TimelineAggregator {
    private long nextIntervalKey = -1L;
    private long lastTimestamp = Long.MAX_VALUE;
    private double lastValue = Double.NEGATIVE_INFINITY;

    public EarliestTimelineAggregator(long interval) {
        super(interval);
    }

    @Override
    public void addValue(Tuple2<Long, Double> value) {
        if (this.nextIntervalKey == (Long)value.f0 / this.interval) {
            if ((Long)value.f0 < this.lastTimestamp) {
                this.lastValue = (Double)value.f1;
                this.lastTimestamp = (Long)value.f0;
            }
        } else if (this.nextIntervalKey < (Long)value.f0 / this.interval) {
            if (this.nextIntervalKey >= 0L) {
                this.currentTimestamp = this.nextIntervalKey * this.interval;
                this.currentValue = this.lastValue;
            }
            this.nextIntervalKey = (Long)value.f0 / this.interval;
            this.lastValue = (Double)value.f1;
            this.lastTimestamp = (Long)value.f0;
        }
    }
}

