/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics.timeline;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggregator;

public class MaxTimelineAggregator
extends TimelineAggregator {
    private long nextIntervalKey = -1L;
    private double max = Double.NEGATIVE_INFINITY;

    public MaxTimelineAggregator(long interval) {
        super(interval);
    }

    @Override
    public void addValue(Tuple2<Long, Double> value) {
        if (this.nextIntervalKey == (Long)value.f0 / this.interval && this.max < (Double)value.f1) {
            this.max = (Double)value.f1;
        } else if (this.nextIntervalKey < (Long)value.f0 / this.interval) {
            if (this.max != Double.NEGATIVE_INFINITY) {
                this.currentTimestamp = this.nextIntervalKey * this.interval;
                this.currentValue = this.max;
            }
            this.nextIntervalKey = (Long)value.f0 / this.interval;
            this.max = (Double)value.f1;
        }
    }
}

