/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics.timeline;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggregator;

public class RateTimelineAggregator
extends TimelineAggregator {
    private long nextIntervalKey = -1L;
    private long maxTimestamp = -1L;
    private long minTimestamp = -1L;
    private double max = Double.NEGATIVE_INFINITY;
    private double min = Double.NEGATIVE_INFINITY;

    public RateTimelineAggregator(long interval) {
        super(interval);
    }

    @Override
    public void addValue(Tuple2<Long, Double> value) {
        if (this.nextIntervalKey == (Long)value.f0 / this.interval) {
            if ((Long)value.f0 > this.maxTimestamp) {
                this.max = (Double)value.f1;
                this.maxTimestamp = (Long)value.f0;
            }
            if ((Long)value.f0 < this.minTimestamp) {
                this.min = (Double)value.f1;
                this.minTimestamp = (Long)value.f0;
            }
        } else if (this.nextIntervalKey < (Long)value.f0 / this.interval) {
            if (this.max != Double.NEGATIVE_INFINITY && this.min != Double.NEGATIVE_INFINITY && this.maxTimestamp != this.minTimestamp) {
                this.currentTimestamp = this.nextIntervalKey * this.interval;
                this.currentValue = (this.max - this.min) * 1000.0 / (double)(this.maxTimestamp - this.minTimestamp);
            }
            this.nextIntervalKey = (Long)value.f0 / this.interval;
            this.max = (Double)value.f1;
            this.maxTimestamp = (Long)value.f0;
            this.min = (Double)value.f1;
            this.minTimestamp = (Long)value.f0;
        }
    }
}

