/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics.timeline;

import org.apache.commons.lang3.NotImplementedException;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.metrics.timeline.AvgTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.DeltaAvgTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.DeltaMaxTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.DeltaMinTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.EarliestTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.LatestTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.LatestValueAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.MaxTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.MinTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.RangeTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.RateTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggType;

public abstract class TimelineAggregator {
    protected long currentTimestamp = -1L;
    protected double currentValue = Double.NEGATIVE_INFINITY;
    protected long interval;

    public TimelineAggregator(long interval) {
        this.interval = interval;
    }

    public abstract void addValue(Tuple2<Long, Double> var1);

    public Tuple2<Long, Double> getValue() {
        if (this.currentTimestamp == -1L) {
            return null;
        }
        return Tuple2.of((Object)this.currentTimestamp, (Object)this.currentValue);
    }

    public static TimelineAggregator createTimelineAggregator(TimelineAggType timelineAggType, long interval) {
        if (interval == 1L) {
            return new LatestValueAggregator(interval);
        }
        switch (timelineAggType) {
            case AVG: {
                return new AvgTimelineAggregator(interval);
            }
            case MAX: {
                return new MaxTimelineAggregator(interval);
            }
            case MIN: {
                return new MinTimelineAggregator(interval);
            }
            case RATE: {
                return new RateTimelineAggregator(interval);
            }
            case RANGE: {
                return new RangeTimelineAggregator(interval);
            }
            case LATEST: {
                return new LatestTimelineAggregator(interval);
            }
            case EARLIEST: {
                return new EarliestTimelineAggregator(interval);
            }
            case DELTA_AVG: {
                return new DeltaAvgTimelineAggregator(interval);
            }
            case DELTA_MIN: {
                return new DeltaMinTimelineAggregator(interval);
            }
            case DELTA_MAX: {
                return new DeltaMaxTimelineAggregator(interval);
            }
        }
        throw new NotImplementedException("Agg type:" + (Object)((Object)timelineAggType));
    }
}

