/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.actions;

import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.runtime.healthmanager.plugins.Action;
import org.apache.flink.runtime.healthmanager.plugins.actions.AdjustJobResource;
import org.apache.flink.runtime.jobgraph.JobVertexID;

public class AdjustJobCpu
extends AdjustJobResource {
    public AdjustJobCpu(JobID jobID, long timeoutMs) {
        super(jobID, timeoutMs);
    }

    @Override
    public AdjustJobResource merge(AdjustJobResource anotherAction) {
        if (!this.jobID.equals((Object)anotherAction.jobID)) {
            return null;
        }
        AdjustJobResource mergedAction = new AdjustJobResource(anotherAction);
        mergedAction.timeoutMs = Math.max(mergedAction.timeoutMs, this.timeoutMs);
        if (this.actionMode == Action.ActionMode.IMMEDIATE) {
            mergedAction.actionMode = Action.ActionMode.IMMEDIATE;
        }
        for (JobVertexID vertexId : this.targetResource.keySet()) {
            if (mergedAction.targetResource.containsKey((Object)vertexId)) {
                mergedAction.targetResource.put(vertexId, new ResourceSpec.Builder((ResourceSpec)mergedAction.targetResource.get((Object)vertexId)).setCpuCores(((ResourceSpec)this.targetResource.get((Object)vertexId)).getCpuCores()).build());
                continue;
            }
            mergedAction.currentResource.put(vertexId, this.currentResource.get((Object)vertexId));
            mergedAction.targetResource.put(vertexId, this.targetResource.get((Object)vertexId));
            mergedAction.currentParallelism.put(vertexId, this.currentParallelism.get((Object)vertexId));
            mergedAction.targetParallelism.put(vertexId, this.targetParallelism.get((Object)vertexId));
        }
        return mergedAction;
    }
}

