/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.actionselectors;

import java.util.List;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.runtime.healthmanager.HealthMonitor;
import org.apache.flink.runtime.healthmanager.plugins.Action;
import org.apache.flink.runtime.healthmanager.plugins.ActionSelector;

public class FirstValidActionSelector
implements ActionSelector {
    private static final ConfigOption<Long> ACTION_BLACK_LIST_INTERVAL = ConfigOptions.key((String)"action.selector.blacklist.interval.ms").defaultValue((Object)300000L);
    private Action lastFailedAction;
    private long lastFailedTime;
    private long blacklistThreshold;

    @Override
    public void open(HealthMonitor monitor) {
        this.blacklistThreshold = monitor.getConfig().getLong(ACTION_BLACK_LIST_INTERVAL);
    }

    @Override
    public void close() {
    }

    @Override
    public Action accept(List<Action> actions) {
        for (Action action : actions) {
            if (this.lastFailedAction != null && action.getClass().equals(this.lastFailedAction.getClass()) && System.currentTimeMillis() - this.lastFailedTime < this.blacklistThreshold) continue;
            return action;
        }
        return null;
    }

    @Override
    public void actionFailed(Action action) {
        this.lastFailedAction = action;
        this.lastFailedTime = System.currentTimeMillis();
    }

    @Override
    public void actionSucceed(Action action) {
    }
}

