/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.detectors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.runtime.healthmanager.HealthMonitor;
import org.apache.flink.runtime.healthmanager.RestServerClient;
import org.apache.flink.runtime.healthmanager.metrics.MetricAggType;
import org.apache.flink.runtime.healthmanager.metrics.MetricProvider;
import org.apache.flink.runtime.healthmanager.metrics.TaskMetricSubscription;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggType;
import org.apache.flink.runtime.healthmanager.plugins.Detector;
import org.apache.flink.runtime.healthmanager.plugins.Symptom;
import org.apache.flink.runtime.healthmanager.plugins.symptoms.JobVertexBackPressure;
import org.apache.flink.runtime.healthmanager.plugins.utils.HealthMonitorOptions;
import org.apache.flink.runtime.healthmanager.plugins.utils.MetricUtils;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackPressureDetector
implements Detector {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackPressureDetector.class);
    private static final ConfigOption<Double> BACK_PRESSURE_THRESHOLD = ConfigOptions.key((String)"healthmonitor.back-pressure.threshold.ms").defaultValue((Object)0.01);
    private JobID jobID;
    private MetricProvider metricProvider;
    private HealthMonitor healthMonitor;
    private long checkInterval;
    private double threshold;
    private Map<JobVertexID, TaskMetricSubscription> waitOutputCountRangeSubs;
    private Map<JobVertexID, TaskMetricSubscription> waitOutputSumRangeSubs;

    @Override
    public void open(HealthMonitor monitor) {
        this.jobID = monitor.getJobID();
        this.healthMonitor = monitor;
        this.metricProvider = monitor.getMetricProvider();
        this.checkInterval = monitor.getConfig().getLong(HealthMonitorOptions.PARALLELISM_SCALE_INTERVAL);
        this.threshold = monitor.getConfig().getDouble(BACK_PRESSURE_THRESHOLD);
        this.waitOutputCountRangeSubs = new HashMap<JobVertexID, TaskMetricSubscription>();
        this.waitOutputSumRangeSubs = new HashMap<JobVertexID, TaskMetricSubscription>();
        RestServerClient.JobConfig jobConfig = monitor.getJobConfig();
        for (JobVertexID vertexId : jobConfig.getVertexConfigs().keySet()) {
            TaskMetricSubscription waitOutputCountRangeSub = this.metricProvider.subscribeTaskMetric(this.jobID, vertexId, "waitOutput.count", MetricAggType.SUM, this.checkInterval, TimelineAggType.RANGE);
            this.waitOutputCountRangeSubs.put(vertexId, waitOutputCountRangeSub);
            TaskMetricSubscription waitOutputSumRangeSub = this.metricProvider.subscribeTaskMetric(this.jobID, vertexId, "waitOutput.sum", MetricAggType.SUM, this.checkInterval, TimelineAggType.RANGE);
            this.waitOutputSumRangeSubs.put(vertexId, waitOutputSumRangeSub);
        }
    }

    @Override
    public void close() {
        if (this.metricProvider == null) {
            return;
        }
        if (this.waitOutputCountRangeSubs != null) {
            for (TaskMetricSubscription sub : this.waitOutputCountRangeSubs.values()) {
                this.metricProvider.unsubscribe(sub);
            }
        }
        if (this.waitOutputSumRangeSubs != null) {
            for (TaskMetricSubscription sub : this.waitOutputSumRangeSubs.values()) {
                this.metricProvider.unsubscribe(sub);
            }
        }
    }

    @Override
    public Symptom detect() throws Exception {
        LOGGER.debug("Start detecting.");
        ArrayList<JobVertexID> jobVertexIDs = new ArrayList<JobVertexID>();
        for (JobVertexID vertexId : this.waitOutputCountRangeSubs.keySet()) {
            TaskMetricSubscription waitOutputSumRangeSub;
            TaskMetricSubscription waitOutputCountRangeSub = this.waitOutputCountRangeSubs.get((Object)vertexId);
            if (!MetricUtils.validateTaskMetric(this.healthMonitor, this.checkInterval * 2L, waitOutputCountRangeSub, waitOutputSumRangeSub = this.waitOutputSumRangeSubs.get((Object)vertexId))) {
                LOGGER.debug("Skip vertex {}, metrics missing.", (Object)vertexId);
                continue;
            }
            double waitOutputCount = (Double)waitOutputCountRangeSub.getValue().f1;
            double waitOutputSum = (Double)waitOutputSumRangeSub.getValue().f1;
            double waitOutputPerRecord = waitOutputCount <= 0.0 ? 0.0 : waitOutputSum / waitOutputCount / 1.0E9;
            LOGGER.debug("vertex {} wait output {}", (Object)vertexId, (Object)waitOutputPerRecord);
            if (!(waitOutputPerRecord > this.threshold)) continue;
            jobVertexIDs.add(vertexId);
            LOGGER.info("Back pressure detected for vertex {} waitOutput:{}.", (Object)vertexId, (Object)waitOutputPerRecord);
        }
        if (!jobVertexIDs.isEmpty()) {
            return new JobVertexBackPressure(this.jobID, jobVertexIDs);
        }
        return null;
    }
}

