/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.detectors;

import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.healthmanager.HealthMonitor;
import org.apache.flink.runtime.healthmanager.RestServerClient;
import org.apache.flink.runtime.healthmanager.plugins.Detector;
import org.apache.flink.runtime.healthmanager.plugins.Symptom;
import org.apache.flink.runtime.healthmanager.plugins.symptoms.JobExceedMaxResourceLimit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceedMaxResourceLimitDetector
implements Detector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceedMaxResourceLimitDetector.class);
    private JobID jobID;
    private RestServerClient restServerClient;
    private long lastDetectTime;

    @Override
    public void open(HealthMonitor monitor) {
        this.jobID = monitor.getJobID();
        this.restServerClient = monitor.getRestServerClient();
        this.lastDetectTime = System.currentTimeMillis();
    }

    @Override
    public void close() {
    }

    @Override
    public Symptom detect() throws Exception {
        LOGGER.debug("Start detecting.");
        JobExceedMaxResourceLimit jobExceedMaxResourceLimit = null;
        Map<Long, Exception> exceptions = this.restServerClient.getTotalResourceLimitExceptions();
        for (Map.Entry<Long, Exception> entry : exceptions.entrySet()) {
            if (entry.getKey() < this.lastDetectTime) continue;
            jobExceedMaxResourceLimit = new JobExceedMaxResourceLimit(this.jobID);
            break;
        }
        this.lastDetectTime = System.currentTimeMillis();
        if (jobExceedMaxResourceLimit != null) {
            LOGGER.info("Direct job exceed max resource limit.");
            return jobExceedMaxResourceLimit;
        }
        return null;
    }
}

