/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.detectors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.runtime.healthmanager.HealthMonitor;
import org.apache.flink.runtime.healthmanager.RestServerClient;
import org.apache.flink.runtime.healthmanager.metrics.JobTMMetricSubscription;
import org.apache.flink.runtime.healthmanager.metrics.MetricProvider;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggType;
import org.apache.flink.runtime.healthmanager.plugins.Detector;
import org.apache.flink.runtime.healthmanager.plugins.Symptom;
import org.apache.flink.runtime.healthmanager.plugins.symptoms.JobVertexLongTimeFullGC;
import org.apache.flink.runtime.healthmanager.plugins.utils.MetricUtils;
import org.apache.flink.runtime.jobgraph.ExecutionVertexID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongTimeFullGCDetector
implements Detector {
    private static final Logger LOGGER = LoggerFactory.getLogger(LongTimeFullGCDetector.class);
    public static final ConfigOption<Long> FULL_GC_TIME_THRESHOLD = ConfigOptions.key((String)"healthmonitor.full-gc-detector.time.threshold.ms").defaultValue((Object)5000L);
    public static final ConfigOption<Long> FULL_GC_TIME_SEVERE_THRESHOLD = ConfigOptions.key((String)"healthmonitor.full-gc-detector.time.severe-threshold.ms").defaultValue((Object)10000L);
    private JobID jobID;
    private RestServerClient restServerClient;
    private MetricProvider metricProvider;
    private HealthMonitor monitor;
    private long gcTimeThreshold;
    private long gcTimeSevereThreshold;
    private final long gcCheckInterval = 1L;
    private JobTMMetricSubscription gcTimeSubscription;
    private JobTMMetricSubscription gcCountSubscription;

    @Override
    public void open(HealthMonitor monitor) {
        this.monitor = monitor;
        this.jobID = monitor.getJobID();
        this.restServerClient = monitor.getRestServerClient();
        this.metricProvider = monitor.getMetricProvider();
        this.gcTimeThreshold = monitor.getConfig().getLong(FULL_GC_TIME_THRESHOLD);
        this.gcTimeSevereThreshold = monitor.getConfig().getLong(FULL_GC_TIME_SEVERE_THRESHOLD);
        this.gcTimeSubscription = this.metricProvider.subscribeAllTMMetric(this.jobID, "Status.JVM.GarbageCollector.ConcurrentMarkSweep.Time", 1L, TimelineAggType.RANGE);
        this.gcCountSubscription = this.metricProvider.subscribeAllTMMetric(this.jobID, "Status.JVM.GarbageCollector.ConcurrentMarkSweep.Count", 1L, TimelineAggType.RANGE);
    }

    @Override
    public void close() {
        if (this.metricProvider != null && this.gcTimeSubscription != null && this.gcCountSubscription != null) {
            this.metricProvider.unsubscribe(this.gcTimeSubscription);
            this.metricProvider.unsubscribe(this.gcCountSubscription);
            this.gcTimeSubscription = null;
            this.gcCountSubscription = null;
        }
    }

    @Override
    public Symptom detect() {
        LOGGER.debug("Start detecting.");
        Object gcTime = this.gcTimeSubscription.getValue();
        Object gcCount = this.gcCountSubscription.getValue();
        if (gcTime == null || gcTime.isEmpty() || gcCount == null || gcCount.isEmpty()) {
            return null;
        }
        boolean severe = false;
        boolean critical = false;
        HashSet jobVertexIDs = new HashSet();
        for (String tmId : gcTime.keySet()) {
            if (!gcCount.containsKey(tmId) || !MetricUtils.validateTmMetric(this.monitor, 1L, (Tuple2)gcTime.get(tmId), (Tuple2)gcCount.get(tmId)) || (Double)((Tuple2)gcCount.get((Object)tmId)).f1 < 1.0) {
                LOGGER.debug("Skip vertex {}, GC metrics missing.", jobVertexIDs);
                continue;
            }
            double perGCDeltaTime = (Double)((Tuple2)gcTime.get((Object)tmId)).f1 / (Double)((Tuple2)gcCount.get((Object)tmId)).f1;
            if (perGCDeltaTime > (double)this.gcTimeThreshold) {
                List<ExecutionVertexID> jobExecutionVertexIds = this.restServerClient.getTaskManagerTasks(tmId);
                if (jobExecutionVertexIds != null) {
                    jobVertexIDs.addAll(jobExecutionVertexIds.stream().map(ExecutionVertexID::getJobVertexID).collect(Collectors.toList()));
                }
                if (perGCDeltaTime > (double)this.gcTimeSevereThreshold) {
                    severe = true;
                    critical = true;
                }
            }
            LOGGER.debug("tm {} gc time {}", (Object)tmId, (Object)perGCDeltaTime);
        }
        if (jobVertexIDs != null && !jobVertexIDs.isEmpty()) {
            LOGGER.info("Long time full gc detected for vertices {}.", jobVertexIDs);
            return new JobVertexLongTimeFullGC(this.jobID, new ArrayList<JobVertexID>(jobVertexIDs), severe, critical);
        }
        return null;
    }
}

