/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.detectors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.runtime.healthmanager.HealthMonitor;
import org.apache.flink.runtime.healthmanager.RestServerClient;
import org.apache.flink.runtime.healthmanager.metrics.JobTMMetricSubscription;
import org.apache.flink.runtime.healthmanager.metrics.MetricProvider;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggType;
import org.apache.flink.runtime.healthmanager.plugins.Detector;
import org.apache.flink.runtime.healthmanager.plugins.Symptom;
import org.apache.flink.runtime.healthmanager.plugins.symptoms.JobVertexLowCpu;
import org.apache.flink.runtime.healthmanager.plugins.utils.HealthMonitorOptions;
import org.apache.flink.runtime.healthmanager.plugins.utils.MetricUtils;
import org.apache.flink.runtime.jobgraph.ExecutionVertexID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowCpuDetector
implements Detector {
    private static final Logger LOGGER = LoggerFactory.getLogger(LowCpuDetector.class);
    public static final ConfigOption<Double> LOW_CPU_THRESHOLD = ConfigOptions.key((String)"healthmonitor.low-cpu-detector.threashold").defaultValue((Object)0.5);
    private JobID jobID;
    private RestServerClient restServerClient;
    private MetricProvider metricProvider;
    private HealthMonitor monitor;
    private long checkInterval;
    private double threshold;
    private long waitTime;
    private JobTMMetricSubscription tmCpuAllocatedSubscription;
    private JobTMMetricSubscription tmCpuUsageSubscription;
    private Map<JobVertexID, Long> lowCpuSince;
    private Map<JobVertexID, Double> maxCpuUsage;
    private Map<JobVertexID, Double> maxCpuUtility;

    @Override
    public void open(HealthMonitor monitor) {
        this.monitor = monitor;
        this.jobID = monitor.getJobID();
        this.restServerClient = monitor.getRestServerClient();
        this.metricProvider = monitor.getMetricProvider();
        this.checkInterval = monitor.getConfig().getLong(HealthMonitorOptions.RESOURCE_SCALE_INTERVAL);
        this.threshold = monitor.getConfig().getDouble(LOW_CPU_THRESHOLD);
        this.waitTime = monitor.getConfig().getLong(HealthMonitorOptions.RESOURCE_SCALE_DOWN_WAIT_TIME);
        this.tmCpuAllocatedSubscription = this.metricProvider.subscribeAllTMMetric(this.jobID, "Status.ProcessTree.CPU.Allocated", this.checkInterval, TimelineAggType.AVG);
        this.tmCpuUsageSubscription = this.metricProvider.subscribeAllTMMetric(this.jobID, "Status.ProcessTree.CPU.Usage", this.checkInterval, TimelineAggType.AVG);
        this.lowCpuSince = new HashMap<JobVertexID, Long>();
        this.maxCpuUsage = new HashMap<JobVertexID, Double>();
        this.maxCpuUtility = new HashMap<JobVertexID, Double>();
    }

    @Override
    public void close() {
        if (this.metricProvider != null && this.tmCpuAllocatedSubscription != null) {
            this.metricProvider.unsubscribe(this.tmCpuAllocatedSubscription);
        }
        if (this.metricProvider != null && this.tmCpuUsageSubscription != null) {
            this.metricProvider.unsubscribe(this.tmCpuUsageSubscription);
        }
    }

    @Override
    public Symptom detect() throws Exception {
        LOGGER.debug("Start detecting.");
        long now = System.currentTimeMillis();
        Object tmCapacities = this.tmCpuAllocatedSubscription.getValue();
        Object tmUsages = this.tmCpuUsageSubscription.getValue();
        if (tmCapacities == null || tmCapacities.isEmpty() || tmUsages == null || tmUsages.isEmpty()) {
            return null;
        }
        this.removeOutdatedMaxUsage();
        HashMap<JobVertexID, Double> vertexTaskMaxUtility = new HashMap<JobVertexID, Double>();
        for (Object tmId : tmCapacities.keySet()) {
            if (!MetricUtils.validateTmMetric(this.monitor, this.checkInterval * 2L, (Tuple2)tmCapacities.get(tmId), (Tuple2)tmUsages.get(tmId))) {
                LOGGER.debug("Skip tm {}, metrics missing.", tmId);
                continue;
            }
            double capacity = (Double)((Tuple2)tmCapacities.get((Object)tmId)).f1;
            double usage = (Double)((Tuple2)tmUsages.get((Object)tmId)).f1;
            if (capacity == 0.0) {
                LOGGER.warn("Skip vertex {}, capacity is 0. SHOULD NOT HAPPEN!", tmId);
                continue;
            }
            double utility = usage / capacity;
            List<ExecutionVertexID> jobExecutionVertexIds = this.restServerClient.getTaskManagerTasks((String)tmId);
            for (ExecutionVertexID jobExecutionVertexId : jobExecutionVertexIds) {
                JobVertexID jvId = jobExecutionVertexId.getJobVertexID();
                if (vertexTaskMaxUtility.containsKey((Object)jvId) && !((Double)vertexTaskMaxUtility.get((Object)jvId) < utility)) continue;
                vertexTaskMaxUtility.put(jvId, utility);
            }
        }
        RestServerClient.JobConfig jobConfig = this.monitor.getJobConfig();
        for (Map.Entry entry : vertexTaskMaxUtility.entrySet()) {
            JobVertexID vertexID = (JobVertexID)((Object)entry.getKey());
            double utility = (Double)entry.getValue();
            if (utility >= this.threshold) {
                this.lowCpuSince.put(vertexID, Long.MAX_VALUE);
                this.maxCpuUsage.remove((Object)vertexID);
                this.maxCpuUtility.remove((Object)vertexID);
            } else {
                double usage = jobConfig.getVertexConfigs().get((Object)vertexID).getResourceSpec().getCpuCores() * utility;
                this.lowCpuSince.put(vertexID, Math.min(now, this.lowCpuSince.getOrDefault((Object)vertexID, Long.MAX_VALUE)));
                this.maxCpuUsage.put(vertexID, Math.max(usage, this.maxCpuUsage.getOrDefault((Object)vertexID, 0.0)));
                this.maxCpuUtility.put(vertexID, Math.max(utility, this.maxCpuUtility.getOrDefault((Object)vertexID, 0.0)));
            }
            LOGGER.debug("Vertex {}, utility {}, lowCpuSince {}, maxCpuUsage {}.", new Object[]{vertexID, utility, this.lowCpuSince.get((Object)vertexID), this.maxCpuUsage.getOrDefault((Object)vertexID, 0.0)});
        }
        HashMap<JobVertexID, Double> vertexMaxUtility = new HashMap<JobVertexID, Double>();
        for (JobVertexID vertexID : this.lowCpuSince.keySet()) {
            if (now - this.lowCpuSince.get((Object)vertexID) <= this.waitTime) continue;
            vertexMaxUtility.put(vertexID, this.maxCpuUtility.get((Object)vertexID));
        }
        if (vertexMaxUtility != null && !vertexMaxUtility.isEmpty()) {
            LOGGER.info("Cpu low detected for vertices with max utilities {}.", vertexMaxUtility);
            return new JobVertexLowCpu(this.jobID, vertexMaxUtility);
        }
        return null;
    }

    private void removeOutdatedMaxUsage() {
        RestServerClient.JobConfig jobConfig = this.monitor.getJobConfig();
        HashSet<JobVertexID> verticeToRemove = new HashSet<JobVertexID>();
        for (JobVertexID vertexID : this.maxCpuUsage.keySet()) {
            double capacity;
            double maxUsage = this.maxCpuUsage.get((Object)vertexID);
            if (!(maxUsage / (capacity = jobConfig.getVertexConfigs().get((Object)vertexID).getResourceSpec().getCpuCores()) >= this.threshold)) continue;
            verticeToRemove.add(vertexID);
            LOGGER.debug("Remove outdated max usage for vertex {}, maxUsage: {}, capacity: {}.", new Object[]{vertexID, maxUsage, capacity});
        }
        for (JobVertexID vertexID : verticeToRemove) {
            this.lowCpuSince.put(vertexID, Long.MAX_VALUE);
            this.maxCpuUsage.remove((Object)vertexID);
            this.maxCpuUtility.remove((Object)vertexID);
        }
    }
}

