/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.symptoms;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.healthmanager.plugins.Symptom;
import org.apache.flink.runtime.jobgraph.JobVertexID;

public class JobVertexLowMemory
implements Symptom {
    private JobID jobID;
    Map<JobVertexID, Double> heapUtilities;
    Map<JobVertexID, Double> nonHeapUtilities;
    Map<JobVertexID, Double> nativeUtilities;

    public JobVertexLowMemory(JobID jobID) {
        this.jobID = jobID;
        this.heapUtilities = new HashMap<JobVertexID, Double>();
        this.nonHeapUtilities = new HashMap<JobVertexID, Double>();
        this.nativeUtilities = new HashMap<JobVertexID, Double>();
    }

    public Map<JobVertexID, Double> getHeapUtilities() {
        return this.heapUtilities;
    }

    public Map<JobVertexID, Double> getNonHeapUtilities() {
        return this.nonHeapUtilities;
    }

    public Map<JobVertexID, Double> getNativeUtilities() {
        return this.nativeUtilities;
    }

    public boolean isEmpty() {
        return this.nativeUtilities.isEmpty();
    }

    public void addVertex(JobVertexID vertexID, double heapUtility, double nonHeapUtility, double nativeUtility) {
        this.heapUtilities.put(vertexID, heapUtility);
        this.nonHeapUtilities.put(vertexID, nonHeapUtility);
        this.nativeUtilities.put(vertexID, nativeUtility);
    }

    public String toString() {
        String vertices = this.heapUtilities.keySet().stream().map(vertexId -> "{JobVertexID:" + (Object)vertexId + ", heapUtility: " + this.heapUtilities.get(vertexId) + ", nonHeapUtility: " + this.nonHeapUtilities.get(vertexId) + ", nativeUtility: " + this.nativeUtilities.get(vertexId) + "}").collect(Collectors.joining(", "));
        return "JobVertexLowMemory{" + vertices + "}";
    }
}

