/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.utils;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.healthmanager.HealthMonitor;
import org.apache.flink.runtime.healthmanager.RestServerClient;
import org.apache.flink.runtime.healthmanager.metrics.TaskMetricSubscription;

public class MetricUtils {
    public static long getStartExecuteTime(HealthMonitor monitor) {
        RestServerClient.JobStatus status;
        long startTime = Long.MIN_VALUE;
        try {
            status = monitor.getRestServerClient().getJobStatus(monitor.getJobID());
        }
        catch (Exception e) {
            return Long.MAX_VALUE;
        }
        for (Tuple2<Long, ExecutionState> state : status.getTaskStatus().values()) {
            if (!((ExecutionState)((Object)state.f1)).equals((Object)ExecutionState.RUNNING)) {
                return Long.MAX_VALUE;
            }
            if (startTime >= (Long)state.f0) continue;
            startTime = (Long)state.f0;
        }
        return startTime;
    }

    public static boolean validateTaskMetric(HealthMonitor monitor, long validInterval, TaskMetricSubscription ... metrics) {
        long now = System.currentTimeMillis();
        for (TaskMetricSubscription metric : metrics) {
            Tuple2<Long, Double> val = metric.getValue();
            if (val != null && (Long)val.f0 >= monitor.getJobStartExecutionTime() && (validInterval <= 1L || now - (Long)val.f0 <= validInterval)) continue;
            return false;
        }
        return true;
    }

    public static boolean validateTmMetric(HealthMonitor monitor, long validInterval, Tuple2<Long, Double> ... metrics) {
        long now = System.currentTimeMillis();
        for (Tuple2<Long, Double> metric : metrics) {
            if (metric != null && (Long)metric.f0 >= monitor.getJobStartExecutionTime() && (validInterval <= 1L || now - (Long)metric.f0 <= validInterval)) continue;
            return false;
        }
        return true;
    }
}

