/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public final class TaskManagerResourceDescription
implements Serializable {
    private static final long serialVersionUID = -6827879526759191662L;
    public static final String FIELD_NAME_SIZE_CPU_CORES = "cpuCores";
    public static final String FIELD_NAME_SIZE_USER_DIRECT_MEMORY = "userDirectMemory";
    public static final String FIELD_NAME_SIZE_USER_HEAP_MEMORY = "userHeapMemory";
    public static final String FIELD_NAME_SIZE_USER_NATIVE_MEMORY = "userNativeMemory";
    public static final String FIELD_NAME_SIZE_MANAGED_MEMORY = "managedMemory";
    public static final String FIELD_NAME_SIZE_NETWORK_MEMORY = "networkMemory";
    @JsonProperty(value="cpuCores")
    private final double numberOfCPUCores;
    @JsonProperty(value="userDirectMemory")
    private final long sizeOfUserDirectMemory;
    @JsonProperty(value="userHeapMemory")
    private final long sizeOfUserHeapMemory;
    @JsonProperty(value="userNativeMemory")
    private final long sizeOfUserNativeMemory;
    @JsonProperty(value="managedMemory")
    private final long sizeOfManagedMemory;
    @JsonProperty(value="networkMemory")
    private final long sizeOfNetworkMemory;

    public double getNumberOfCPUCores() {
        return this.numberOfCPUCores;
    }

    public long getSizeOfUserDirectMemory() {
        return this.sizeOfUserDirectMemory;
    }

    public long getSizeOfUserHeapMemory() {
        return this.sizeOfUserHeapMemory;
    }

    public long getSizeOfUserNativeMemory() {
        return this.sizeOfUserNativeMemory;
    }

    public long getSizeOfManagedMemory() {
        return this.sizeOfManagedMemory;
    }

    public long getSizeOfNetworkMemory() {
        return this.sizeOfNetworkMemory;
    }

    @JsonCreator
    public TaskManagerResourceDescription(@JsonProperty(value="cpuCores") double numberOfCPUCores, @JsonProperty(value="userDirectMemory") long sizeOfUserDirectMemory, @JsonProperty(value="userHeapMemory") long sizeOfUserHeapMemory, @JsonProperty(value="userNativeMemory") long sizeOfUserNativeMemory, @JsonProperty(value="managedMemory") long sizeOfManagedMemory, @JsonProperty(value="networkMemory") long sizeOfNetworkMemory) {
        this.numberOfCPUCores = numberOfCPUCores;
        this.sizeOfUserDirectMemory = sizeOfUserDirectMemory;
        this.sizeOfUserHeapMemory = sizeOfUserHeapMemory;
        this.sizeOfUserNativeMemory = sizeOfUserNativeMemory;
        this.sizeOfManagedMemory = sizeOfManagedMemory;
        this.sizeOfNetworkMemory = sizeOfNetworkMemory;
    }

    public static TaskManagerResourceDescription fromResourceProfile(ResourceProfile resourceProfile) {
        return new TaskManagerResourceDescription(resourceProfile.getCpuCores(), (long)resourceProfile.getDirectMemoryInMB() << 20, (long)resourceProfile.getHeapMemoryInMB() << 20, (long)resourceProfile.getNativeMemoryInMB() << 20, (long)resourceProfile.getManagedMemoryInMB() << 20, (long)resourceProfile.getNetworkMemoryInMB() << 20);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskManagerResourceDescription that = (TaskManagerResourceDescription)o;
        return this.numberOfCPUCores == that.numberOfCPUCores && this.sizeOfUserDirectMemory == that.sizeOfUserDirectMemory && this.sizeOfUserHeapMemory == that.sizeOfUserHeapMemory && this.sizeOfUserNativeMemory == that.sizeOfUserNativeMemory && this.sizeOfManagedMemory == that.sizeOfManagedMemory && this.sizeOfNetworkMemory == that.sizeOfNetworkMemory;
    }

    public int hashCode() {
        return Objects.hash(this.numberOfCPUCores, this.sizeOfUserDirectMemory, this.sizeOfUserHeapMemory, this.sizeOfUserNativeMemory, this.sizeOfManagedMemory, this.sizeOfNetworkMemory);
    }

    public String toString() {
        return String.format("cores=%s, userDirect=%d, userHeap=%d, userNative=%d, managed=%d, network=%d", this.numberOfCPUCores, this.sizeOfUserDirectMemory, this.sizeOfUserHeapMemory, this.sizeOfUserNativeMemory, this.sizeOfManagedMemory, this.sizeOfNetworkMemory);
    }
}

