/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.QueuingCallback;
import org.apache.flink.runtime.io.disk.iomanager.ReadRequest;
import org.apache.flink.runtime.io.disk.iomanager.RequestQueue;
import org.apache.flink.runtime.io.disk.iomanager.SeekRequest;
import org.apache.flink.runtime.io.disk.iomanager.SegmentReadRequest;

public class AsynchronousBlockReader
extends AsynchronousFileIOChannel<MemorySegment, ReadRequest>
implements BlockChannelReader<MemorySegment> {
    private final LinkedBlockingQueue<MemorySegment> returnSegments;
    private final int bufferSize;

    protected AsynchronousBlockReader(FileIOChannel.ID channelID, RequestQueue<ReadRequest> requestQueue, LinkedBlockingQueue<MemorySegment> returnSegments, int bufferSize) throws IOException {
        super(channelID, requestQueue, new QueuingCallback<MemorySegment>(returnSegments), false);
        this.returnSegments = returnSegments;
        this.bufferSize = bufferSize;
    }

    @Override
    public void readBlock(MemorySegment segment) throws IOException {
        this.addRequest(new SegmentReadRequest(this, segment, this.bufferSize));
    }

    @Override
    public void seekToPosition(long position) throws IOException {
        this.requestQueue.add(new SeekRequest(this, position, this.bufferSize));
    }

    @Override
    public MemorySegment getNextReturnedBlock() throws IOException {
        try {
            while (true) {
                MemorySegment next;
                if ((next = this.returnSegments.poll(1000L, TimeUnit.MILLISECONDS)) != null) {
                    return next;
                }
                if (this.closed) {
                    throw new IOException("The reader has been asynchronously closed.");
                }
                this.checkErroneous();
            }
        }
        catch (InterruptedException iex) {
            throw new IOException("Reader was interrupted while waiting for the next returning segment.");
        }
    }

    @Override
    public LinkedBlockingQueue<MemorySegment> getReturnQueue() {
        return this.returnSegments;
    }
}

