/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileReader;
import org.apache.flink.runtime.io.disk.iomanager.BufferReadRequest;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.ReadRequest;
import org.apache.flink.runtime.io.disk.iomanager.RequestDoneCallback;
import org.apache.flink.runtime.io.disk.iomanager.RequestQueue;
import org.apache.flink.runtime.io.disk.iomanager.SeekRequest;
import org.apache.flink.runtime.io.disk.iomanager.StreamReadRequest;
import org.apache.flink.runtime.io.network.buffer.Buffer;

public class AsynchronousBufferFileReader
extends AsynchronousFileIOChannel<Buffer, ReadRequest>
implements BufferFileReader {
    private final AtomicBoolean hasReachedEndOfFile = new AtomicBoolean();
    private final int bufferSize;
    private final boolean withHeader;
    private long currentPosition;

    protected AsynchronousBufferFileReader(FileIOChannel.ID channelID, RequestQueue<ReadRequest> requestQueue, RequestDoneCallback<Buffer> callback, int bufferSize) throws IOException {
        this(channelID, requestQueue, callback, bufferSize, true);
    }

    protected AsynchronousBufferFileReader(FileIOChannel.ID channelID, RequestQueue<ReadRequest> requestQueue, RequestDoneCallback<Buffer> callback, int bufferSize, boolean withHeader) throws IOException {
        super(channelID, requestQueue, callback, false);
        this.bufferSize = bufferSize;
        this.withHeader = withHeader;
    }

    @Override
    public void readInto(Buffer buffer) throws IOException {
        if (!this.withHeader) {
            throw new IllegalArgumentException("Method readInto(Buffer buffer) only support withHeader mode.");
        }
        this.addRequest(new BufferReadRequest(this, buffer, this.hasReachedEndOfFile, this.bufferSize));
    }

    @Override
    public void readInto(Buffer buffer, long length) throws IOException {
        if (!this.withHeader) {
            this.addRequest(new StreamReadRequest(this, buffer, this.hasReachedEndOfFile, this.currentPosition, length, this.bufferSize));
            this.currentPosition += length;
        } else {
            throw new IllegalArgumentException("Method readInto(Buffer buffer, long length) only support withoutHeader mode.");
        }
    }

    @Override
    public void seekToPosition(long position) throws IOException {
        this.currentPosition = position;
        this.requestQueue.add(new SeekRequest(this, position, this.bufferSize));
    }

    @Override
    public boolean hasReachedEndOfFile() {
        return this.hasReachedEndOfFile.get();
    }
}

