/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.ReadRequest;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.util.NioBufferedFileInputStream;

final class BufferReadRequest
implements ReadRequest {
    private final AsynchronousFileIOChannel<Buffer, ReadRequest> channel;
    private final Buffer buffer;
    private final AtomicBoolean hasReachedEndOfFile;
    private final int bufferSize;

    protected BufferReadRequest(AsynchronousFileIOChannel<Buffer, ReadRequest> targetChannel, Buffer buffer, AtomicBoolean hasReachedEndOfFile, int bufferSize) {
        this.channel = targetChannel;
        this.buffer = buffer;
        this.hasReachedEndOfFile = hasReachedEndOfFile;
        this.bufferSize = bufferSize;
    }

    @Override
    public void read() throws IOException {
        FileChannel fileChannel = this.channel.fileChannel;
        if (this.bufferSize == -1) {
            if (fileChannel.size() - fileChannel.position() > 0L) {
                BufferFileChannelReader reader = new BufferFileChannelReader(fileChannel);
                this.hasReachedEndOfFile.set(reader.readBufferFromFileChannel(this.buffer));
            } else {
                this.hasReachedEndOfFile.set(true);
            }
        } else {
            NioBufferedFileInputStream in = this.channel.getBufferedInputStream(this.bufferSize);
            if (in.available() > 0) {
                BufferFileChannelReader reader = new BufferFileChannelReader(fileChannel);
                this.hasReachedEndOfFile.set(reader.readBufferFromFileBufferedChannel(in, this.buffer));
            } else {
                this.hasReachedEndOfFile.set(true);
            }
        }
    }

    @Override
    public void requestDone(IOException error) {
        this.channel.handleProcessedBuffer(this.buffer, error);
    }
}

