/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.WriteRequest;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.util.NioBufferedFileOutputStream;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;

final class BufferWriteRequest
implements WriteRequest {
    private final AsynchronousFileIOChannel<Buffer, WriteRequest> channel;
    private final Buffer buffer;
    private final int bufferSize;

    protected BufferWriteRequest(AsynchronousFileIOChannel<Buffer, WriteRequest> targetChannel, Buffer buffer, int bufferSize) {
        this.channel = (AsynchronousFileIOChannel)Preconditions.checkNotNull(targetChannel);
        this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer);
        this.bufferSize = bufferSize;
    }

    @Override
    public void write() throws IOException {
        ByteBuffer nioBufferReadable = this.buffer.getNioBufferReadable();
        ByteBuffer header = ByteBuffer.allocate(8);
        header.putInt(this.buffer.isBuffer() ? 1 : 0);
        header.putInt(nioBufferReadable.remaining());
        header.flip();
        if (this.bufferSize == -1) {
            FileUtils.writeCompletely((WritableByteChannel)this.channel.fileChannel, (ByteBuffer)header);
            FileUtils.writeCompletely((WritableByteChannel)this.channel.fileChannel, (ByteBuffer)nioBufferReadable);
        } else {
            NioBufferedFileOutputStream out = this.channel.getBufferedOutputStream(this.bufferSize);
            out.write(header);
            out.write(nioBufferReadable);
        }
    }

    @Override
    public void requestDone(IOException error) {
        this.channel.handleProcessedBuffer(this.buffer, error);
    }
}

