/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.AbstractChannelReaderInputView;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;

public class ChannelReaderInputView
extends AbstractChannelReaderInputView {
    protected final BlockChannelReader<MemorySegment> reader;
    protected int numRequestsRemaining;
    private final int numSegments;
    private final ArrayList<MemorySegment> freeMem;
    private boolean inLastBlock;
    private boolean closed;

    public ChannelReaderInputView(BlockChannelReader<MemorySegment> reader, List<MemorySegment> memory, boolean waitForFirstBlock) throws IOException {
        this(reader, memory, -1, waitForFirstBlock);
    }

    public ChannelReaderInputView(BlockChannelReader<MemorySegment> reader, List<MemorySegment> memory, int numBlocks, boolean waitForFirstBlock) throws IOException {
        this(reader, memory, numBlocks, 8, waitForFirstBlock);
    }

    ChannelReaderInputView(BlockChannelReader<MemorySegment> reader, List<MemorySegment> memory, int numBlocks, int headerLen, boolean waitForFirstBlock) throws IOException {
        super(headerLen);
        if (reader == null || memory == null) {
            throw new NullPointerException();
        }
        if (memory.isEmpty()) {
            throw new IllegalArgumentException("Empty list of memory segments given.");
        }
        if (numBlocks < 1 && numBlocks != -1) {
            throw new IllegalArgumentException("The number of blocks must be a positive number, or -1, if unknown.");
        }
        this.reader = reader;
        this.numRequestsRemaining = numBlocks;
        this.numSegments = memory.size();
        this.freeMem = new ArrayList(this.numSegments);
        for (int i = 0; i < memory.size(); ++i) {
            this.sendReadRequest(memory.get(i));
        }
        if (waitForFirstBlock) {
            this.advance();
        }
    }

    public void waitForFirstBlock() throws IOException {
        if (this.getCurrentSegment() == null) {
            this.advance();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public List<MemorySegment> close() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Already closed.");
        }
        this.closed = true;
        ArrayList<MemorySegment> list = this.freeMem;
        MemorySegment current = this.getCurrentSegment();
        if (current != null) {
            list.add(current);
        }
        this.clear();
        LinkedBlockingQueue<MemorySegment> queue = this.reader.getReturnQueue();
        this.reader.close();
        while (list.size() < this.numSegments) {
            MemorySegment m = queue.poll();
            if (m == null) {
                throw new RuntimeException("Bug in ChannelReaderInputView: MemorySegments lost.");
            }
            list.add(m);
        }
        return list;
    }

    protected MemorySegment nextSegment(MemorySegment current) throws IOException {
        MemorySegment seg;
        if (this.inLastBlock) {
            throw new EOFException();
        }
        if (current != null) {
            this.sendReadRequest(current);
        }
        if ((seg = this.reader.getNextReturnedBlock()).getShort(0) != -16130) {
            throw new IOException("The current block does not belong to a ChannelWriterOutputView / ChannelReaderInputView: Wrong magic number.");
        }
        if ((seg.getShort(2) & 1) != 0) {
            this.numRequestsRemaining = 0;
            this.inLastBlock = true;
        }
        return seg;
    }

    protected int getLimitForSegment(MemorySegment segment) {
        return segment.getInt(4);
    }

    protected void sendReadRequest(MemorySegment seg) throws IOException {
        if (this.numRequestsRemaining != 0) {
            this.reader.readBlock(seg);
            if (this.numRequestsRemaining != -1) {
                --this.numRequestsRemaining;
            }
        } else {
            this.freeMem.add(seg);
        }
    }

    @Override
    public FileIOChannel getChannel() {
        return this.reader;
    }

    @Override
    public void closeAndDelete() throws IOException {
        this.reader.closeAndDelete();
    }
}

