/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.util.StringUtils;

public interface FileIOChannel {
    public ID getChannelID();

    public long getSize() throws IOException;

    public boolean isClosed();

    public void close() throws IOException;

    public void deleteChannel();

    public void closeAndDelete() throws IOException;

    public FileChannel getNioFileChannel();

    public static final class Enumerator {
        private static AtomicInteger globalCounter = new AtomicInteger();
        private final File[] paths;
        private final String namePrefix;
        private final int numThread;
        private int localCounter;

        protected Enumerator(File[] basePaths, Random random, int numThread) {
            this.paths = basePaths;
            this.namePrefix = ID.randomString(random);
            this.numThread = numThread;
            this.localCounter = 0;
        }

        public ID next() {
            int currentCounter = globalCounter.get();
            int pathNum = currentCounter % this.paths.length;
            int threadNum = currentCounter % this.numThread;
            globalCounter.getAndIncrement();
            String filename = String.format("%s.%06d.channel", this.namePrefix, this.localCounter++);
            return new ID(new File(this.paths[pathNum], filename), threadNum);
        }
    }

    public static class ID {
        private static final int RANDOM_BYTES_LENGTH = 16;
        private final File path;
        private final int threadNum;

        public ID(String path) {
            this.path = new File(path);
            this.threadNum = 0;
        }

        protected ID(File path, int threadNum) {
            this.path = path;
            this.threadNum = threadNum;
        }

        protected ID(File basePath, int threadNum, Random random) {
            this.path = new File(basePath, ID.randomString(random) + ".channel");
            this.threadNum = threadNum;
        }

        public String getPath() {
            return this.path.getAbsolutePath();
        }

        public File getPathFile() {
            return this.path;
        }

        int getThreadNum() {
            return this.threadNum;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ID) {
                ID other = (ID)obj;
                return this.path.equals(other.path) && this.threadNum == other.threadNum;
            }
            return false;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public String toString() {
            return this.path.getAbsolutePath();
        }

        private static String randomString(Random random) {
            byte[] bytes = new byte[16];
            random.nextBytes(bytes);
            return StringUtils.byteToHexString((byte[])bytes);
        }
    }
}

