/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.FileSegment;
import org.apache.flink.runtime.io.disk.iomanager.ReadRequest;

final class FileSegmentReadRequest
implements ReadRequest {
    private final AsynchronousFileIOChannel<FileSegment, ReadRequest> channel;
    private final AtomicBoolean hasReachedEndOfFile;
    private FileSegment fileSegment;

    protected FileSegmentReadRequest(AsynchronousFileIOChannel<FileSegment, ReadRequest> targetChannel, AtomicBoolean hasReachedEndOfFile) {
        this.channel = targetChannel;
        this.hasReachedEndOfFile = hasReachedEndOfFile;
    }

    @Override
    public void read() throws IOException {
        FileChannel fileChannel = this.channel.fileChannel;
        if (fileChannel.size() - fileChannel.position() > 0L) {
            ByteBuffer header = ByteBuffer.allocate(8);
            fileChannel.read(header);
            header.flip();
            long position = fileChannel.position();
            boolean isBuffer = header.getInt() == 1;
            int length = header.getInt();
            this.fileSegment = new FileSegment(fileChannel, position, length, isBuffer);
            fileChannel.position(position + (long)length);
            this.hasReachedEndOfFile.set(fileChannel.size() - fileChannel.position() == 0L);
        } else {
            this.hasReachedEndOfFile.set(true);
        }
    }

    @Override
    public void requestDone(IOException error) {
        this.channel.handleProcessedBuffer(this.fileSegment, error);
    }
}

