/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.ReadRequest;
import org.apache.flink.runtime.io.disk.iomanager.WriteRequest;

final class SeekRequest
implements ReadRequest,
WriteRequest {
    private final AsynchronousFileIOChannel<?, ?> channel;
    private final long position;
    private final int bufferSize;

    protected SeekRequest(AsynchronousFileIOChannel<?, ?> channel, long position) {
        this(channel, position, -1);
    }

    protected SeekRequest(AsynchronousFileIOChannel<?, ?> channel, long position, int bufferSize) {
        this.channel = channel;
        this.position = position;
        this.bufferSize = bufferSize;
    }

    @Override
    public void requestDone(IOException ioex) {
    }

    @Override
    public void read() throws IOException {
        if (this.bufferSize != -1) {
            this.channel.getBufferedInputStream(this.bufferSize).clearBuffer();
        }
        this.channel.fileChannel.position(this.position);
    }

    @Override
    public void write() throws IOException {
        if (this.bufferSize != -1) {
            this.channel.getBufferedOutputStream(this.bufferSize).flush();
        }
        this.channel.fileChannel.position(this.position);
    }
}

