/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.ReadRequest;
import org.apache.flink.runtime.util.NioBufferedFileInputStream;

final class SegmentReadRequest
implements ReadRequest {
    private final AsynchronousFileIOChannel<MemorySegment, ReadRequest> channel;
    private final MemorySegment segment;
    private final int bufferSize;

    protected SegmentReadRequest(AsynchronousFileIOChannel<MemorySegment, ReadRequest> targetChannel, MemorySegment segment, int bufferSize) {
        this.bufferSize = bufferSize;
        if (segment == null) {
            throw new NullPointerException("Illegal read request with null memory segment.");
        }
        this.channel = targetChannel;
        this.segment = segment;
    }

    @Override
    public void read() throws IOException {
        try {
            if (this.bufferSize == -1) {
                FileChannel c = this.channel.fileChannel;
                if (c.size() - c.position() > 0L) {
                    this.channel.fileChannel.read(this.segment.wrap(0, this.segment.size()));
                }
            } else {
                NioBufferedFileInputStream in = this.channel.getBufferedInputStream(this.bufferSize);
                if (in.available() > 0) {
                    in.continuousRead(this.segment.wrap(0, this.segment.size()));
                }
            }
        }
        catch (NullPointerException ignored) {
            throw new IOException("Memory segment has been released.");
        }
    }

    @Override
    public void requestDone(IOException ioex) {
        this.channel.handleProcessedBuffer(this.segment, ioex);
    }
}

