/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.util.NioBufferedFileInputStream;
import org.apache.flink.util.Preconditions;

public final class StreamFileChannelReader {
    public static boolean readBufferFromFileChannel(FileChannel fileChannel, Buffer buffer, long offset, long length, File file) throws IOException {
        long currPosition = fileChannel.position();
        if (currPosition != offset) {
            throw new IllegalStateException("Expect fileChannel's position to be " + offset + ", but the current position is " + currPosition + ", fileId: " + file);
        }
        Preconditions.checkArgument((buffer.getSize() == 0 ? 1 : 0) != 0, (Object)"Buffer not empty");
        if (length > (long)buffer.getMaxCapacity()) {
            throw new IllegalStateException("Buffer is too small for data: " + buffer.getMaxCapacity() + " bytes available, but " + length + " needed. This is most likely due to an serialized event, which is larger than the buffer size.");
        }
        if (fileChannel.size() - currPosition < length) {
            throw new IllegalStateException("Cannot read " + length + "bytes from this file, file size: " + fileChannel.size() + ", current position: " + currPosition + ", fileId: " + file);
        }
        fileChannel.read(buffer.getNioBuffer(0, (int)length));
        buffer.setSize((int)length);
        return fileChannel.size() - fileChannel.position() == 0L;
    }

    public static boolean readBufferFromFileBufferedChannel(NioBufferedFileInputStream in, Buffer buffer, long offset, long length, File file) throws IOException {
        long currPosition = in.position();
        if (currPosition != offset) {
            throw new IllegalStateException("Expect fileChannel's position to be " + offset + ", but the current position is " + currPosition + ", fileId: " + file);
        }
        Preconditions.checkArgument((buffer.getSize() == 0 ? 1 : 0) != 0, (Object)"Buffer not empty");
        if (length > (long)buffer.getMaxCapacity()) {
            throw new IllegalStateException("Buffer is too small for data: " + buffer.getMaxCapacity() + " bytes available, but " + length + " needed. This is most likely due to an serialized event, which is larger than the buffer size.");
        }
        if (in.size() - currPosition < length) {
            throw new IllegalStateException("Cannot read " + length + "bytes from this file, file size: " + in.size() + ", current position: " + currPosition + ", fileId: " + file);
        }
        in.continuousRead(buffer.getNioBuffer(0, (int)length));
        buffer.setSize((int)length);
        return in.size() - in.position() == 0L;
    }
}

