/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.WriteRequest;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.util.NioBufferedFileOutputStream;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;

final class StreamWriteRequest
implements WriteRequest {
    private final AsynchronousFileIOChannel<Buffer, WriteRequest> channel;
    private final Buffer buffer;
    private final int bufferSize;

    protected StreamWriteRequest(AsynchronousFileIOChannel<Buffer, WriteRequest> targetChannel, Buffer buffer, int bufferSize) {
        this.channel = (AsynchronousFileIOChannel)Preconditions.checkNotNull(targetChannel);
        this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer);
        this.bufferSize = bufferSize;
    }

    @Override
    public void write() throws IOException {
        Preconditions.checkArgument((boolean)this.buffer.isBuffer(), (Object)"Cannot write event buffer in StreamWriteRequest.");
        if (this.bufferSize == -1) {
            FileUtils.writeCompletely((WritableByteChannel)this.channel.fileChannel, (ByteBuffer)this.buffer.getNioBufferReadable());
        } else {
            NioBufferedFileOutputStream out = this.channel.getBufferedOutputStream(this.bufferSize);
            out.write(this.buffer.getNioBufferReadable());
        }
    }

    @Override
    public void requestDone(IOException error) {
        this.channel.handleProcessedBuffer(this.buffer, error);
    }
}

