/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network;

import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;

public enum DataExchangeMode {
    AUTO,
    PIPELINED,
    BATCH,
    PIPELINE_WITH_BATCH_FALLBACK;

    private static final DataExchangeMode[] FORWARD;
    private static final DataExchangeMode[] SHUFFLE;
    private static final DataExchangeMode[] BREAKING;

    public static DataExchangeMode getForForwardExchange(ExecutionMode mode) {
        return FORWARD[mode.ordinal()];
    }

    public static DataExchangeMode getForShuffleOrBroadcast(ExecutionMode mode) {
        return SHUFFLE[mode.ordinal()];
    }

    public static DataExchangeMode getPipelineBreakingExchange(ExecutionMode mode) {
        return BREAKING[mode.ordinal()];
    }

    public static DataExchangeMode select(ExecutionMode executionMode, ShipStrategyType shipStrategy, boolean breakPipeline) {
        if (shipStrategy == null || shipStrategy == ShipStrategyType.NONE) {
            throw new IllegalArgumentException("shipStrategy may not be null or NONE");
        }
        if (executionMode == null) {
            throw new IllegalArgumentException("executionMode may not mbe null");
        }
        if (breakPipeline) {
            return DataExchangeMode.getPipelineBreakingExchange(executionMode);
        }
        if (shipStrategy == ShipStrategyType.FORWARD) {
            return DataExchangeMode.getForForwardExchange(executionMode);
        }
        return DataExchangeMode.getForShuffleOrBroadcast(executionMode);
    }

    static {
        FORWARD = new DataExchangeMode[ExecutionMode.values().length];
        SHUFFLE = new DataExchangeMode[ExecutionMode.values().length];
        BREAKING = new DataExchangeMode[ExecutionMode.values().length];
        DataExchangeMode.FORWARD[ExecutionMode.PIPELINED_FORCED.ordinal()] = PIPELINED;
        DataExchangeMode.SHUFFLE[ExecutionMode.PIPELINED_FORCED.ordinal()] = PIPELINED;
        DataExchangeMode.BREAKING[ExecutionMode.PIPELINED_FORCED.ordinal()] = PIPELINED;
        DataExchangeMode.FORWARD[ExecutionMode.PIPELINED.ordinal()] = PIPELINED;
        DataExchangeMode.SHUFFLE[ExecutionMode.PIPELINED.ordinal()] = PIPELINED;
        DataExchangeMode.BREAKING[ExecutionMode.PIPELINED.ordinal()] = BATCH;
        DataExchangeMode.FORWARD[ExecutionMode.BATCH.ordinal()] = PIPELINED;
        DataExchangeMode.SHUFFLE[ExecutionMode.BATCH.ordinal()] = BATCH;
        DataExchangeMode.BREAKING[ExecutionMode.BATCH.ordinal()] = BATCH;
        DataExchangeMode.FORWARD[ExecutionMode.BATCH_FORCED.ordinal()] = BATCH;
        DataExchangeMode.SHUFFLE[ExecutionMode.BATCH_FORCED.ordinal()] = BATCH;
        DataExchangeMode.BREAKING[ExecutionMode.BATCH_FORCED.ordinal()] = BATCH;
    }
}

