/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.network.api.serialization.BufferSerializationDelegate;
import org.apache.flink.runtime.io.network.api.serialization.RecordSerializer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.util.Preconditions;

public class CompositeSpanningRecordSerializer<T extends IOReadableWritable>
implements RecordSerializer<T> {
    private final DataOutputSerializer serializationBuffer;
    private final int maxBufferLenForInternalSer;
    private final RecordSerializer<BufferSerializationDelegate> subSerializer;
    private final BufferSerializationDelegate subSerializationDelegate;
    private RecordSerializer.SerializationResult subSerializationResult;
    private ByteBuffer subSerializationBuffer;

    public CompositeSpanningRecordSerializer(RecordSerializer<BufferSerializationDelegate> subSerializer, BufferSerializationDelegate subSerializationDelegate, int subSerBufferLength) {
        Preconditions.checkNotNull(subSerializer);
        Preconditions.checkNotNull((Object)subSerializationDelegate);
        this.subSerializer = subSerializer;
        this.subSerializationDelegate = subSerializationDelegate;
        this.maxBufferLenForInternalSer = subSerBufferLength;
        this.serializationBuffer = new DataOutputSerializer(subSerBufferLength << 1);
        this.subSerializationResult = RecordSerializer.SerializationResult.FULL_RECORD;
    }

    @Override
    public void serializeRecord(T record) throws IOException {
        int prevPosition = this.serializationBuffer.position();
        this.serializationBuffer.skipBytesToWrite(4);
        record.write((DataOutputView)this.serializationBuffer);
        int newPosition = this.serializationBuffer.position();
        this.serializationBuffer.position(prevPosition);
        this.serializationBuffer.writeInt(newPosition - prevPosition - 4);
        this.serializationBuffer.position(newPosition);
    }

    private RecordSerializer.SerializationResult copyOrFlushToBufferBuilder(BufferBuilder targetBuffer, boolean needFlush) {
        int currentInternalBufferLimit;
        int n = currentInternalBufferLimit = !needFlush ? this.maxBufferLenForInternalSer : 1;
        if (this.subSerializationResult == RecordSerializer.SerializationResult.PARTIAL_RECORD_MEMORY_SEGMENT_FULL) {
            RecordSerializer.SerializationResult serializationResult = this.subSerializationResult = !needFlush ? this.subSerializer.copyToBufferBuilder(targetBuffer) : this.subSerializer.flushToBufferBuilder(targetBuffer);
            if (this.subSerializationResult == RecordSerializer.SerializationResult.FULL_RECORD_MEMORY_SEGMENT_FULL) {
                if (this.subSerializationBuffer == null && this.serializationBuffer.length() < currentInternalBufferLimit) {
                    return RecordSerializer.SerializationResult.FULL_RECORD_MEMORY_SEGMENT_FULL;
                }
                return RecordSerializer.SerializationResult.PARTIAL_RECORD_MEMORY_SEGMENT_FULL;
            }
            if (this.subSerializationResult == RecordSerializer.SerializationResult.PARTIAL_RECORD_MEMORY_SEGMENT_FULL) {
                return RecordSerializer.SerializationResult.PARTIAL_RECORD_MEMORY_SEGMENT_FULL;
            }
        }
        if (this.subSerializationBuffer == null) {
            if (this.serializationBuffer.length() < currentInternalBufferLimit) {
                return RecordSerializer.SerializationResult.FULL_RECORD;
            }
            this.subSerializationBuffer = this.serializationBuffer.wrapAsByteBuffer();
        }
        while (this.subSerializationBuffer != null) {
            int position = this.subSerializationBuffer.position();
            int nextLen = Math.min(this.subSerializationBuffer.remaining(), this.maxBufferLenForInternalSer);
            ByteBuffer nextBufferForInternalSer = ByteBuffer.wrap(this.subSerializationBuffer.array(), position, nextLen);
            this.subSerializationDelegate.setBuffer(nextBufferForInternalSer);
            try {
                this.subSerializer.serializeRecord(this.subSerializationDelegate);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.subSerializer.reset();
            this.subSerializationResult = this.subSerializer.copyToBufferBuilder(targetBuffer);
            this.subSerializationBuffer.position(position + nextLen);
            if (this.subSerializationBuffer.remaining() < currentInternalBufferLimit) {
                int nextPosition = this.subSerializationBuffer.remaining();
                if (this.subSerializationBuffer.remaining() > 0) {
                    System.arraycopy(this.serializationBuffer.getSharedBuffer(), this.subSerializationBuffer.position(), this.serializationBuffer.getSharedBuffer(), 0, this.subSerializationBuffer.remaining());
                }
                this.serializationBuffer.clear();
                this.serializationBuffer.position(nextPosition);
                this.subSerializationBuffer = null;
                break;
            }
            if (!this.subSerializationResult.isFullBuffer()) continue;
            break;
        }
        if (this.subSerializationResult == RecordSerializer.SerializationResult.PARTIAL_RECORD_MEMORY_SEGMENT_FULL || this.subSerializationBuffer != null) {
            return RecordSerializer.SerializationResult.PARTIAL_RECORD_MEMORY_SEGMENT_FULL;
        }
        return !targetBuffer.isFull() ? RecordSerializer.SerializationResult.FULL_RECORD : RecordSerializer.SerializationResult.FULL_RECORD_MEMORY_SEGMENT_FULL;
    }

    @Override
    public RecordSerializer.SerializationResult copyToBufferBuilder(BufferBuilder targetBuffer) {
        return this.copyOrFlushToBufferBuilder(targetBuffer, false);
    }

    @Override
    public RecordSerializer.SerializationResult flushToBufferBuilder(BufferBuilder targetBuffer) {
        return this.copyOrFlushToBufferBuilder(targetBuffer, true);
    }

    @Override
    public void reset() {
        this.subSerializer.reset();
    }

    @Override
    public void prune() {
        this.serializationBuffer.pruneBuffer();
        this.subSerializer.prune();
    }

    @Override
    public boolean hasSerializedData() {
        return this.serializationBuffer.length() > 0 || this.subSerializationBuffer != null || this.subSerializer.hasSerializedData();
    }
}

