/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.serialization.BufferDeserializationDelegate;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.SpillingAdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;

public class CompositeSpillingAdaptiveSpanningRecordDeserializer<T extends IOReadableWritable>
implements RecordDeserializer<T> {
    private final SpillingAdaptiveSpanningRecordDeserializer<T> innerDeserializer;
    private RecordDeserializer.DeserializationResult innerDeserializationResult;
    private final RecordDeserializer<BufferDeserializationDelegate> subDeserializer;
    private final BufferDeserializationDelegate subDeserializationDelegate;
    private RecordDeserializer.DeserializationResult subDeserializationResult;

    public CompositeSpillingAdaptiveSpanningRecordDeserializer(String[] tmpDirectories, RecordDeserializer<BufferDeserializationDelegate> subDeserializer, BufferDeserializationDelegate subDeserializationDelegate) {
        assert (subDeserializer != null);
        assert (subDeserializationDelegate != null);
        this.innerDeserializer = new SpillingAdaptiveSpanningRecordDeserializer(tmpDirectories);
        this.innerDeserializationResult = RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER;
        this.subDeserializer = subDeserializer;
        this.subDeserializationDelegate = subDeserializationDelegate;
        this.subDeserializationResult = RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER;
    }

    @Override
    public void setNextBuffer(Buffer buffer) throws IOException {
        this.subDeserializer.setNextBuffer(buffer);
        this.subDeserializationResult = RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER;
    }

    @Override
    public Buffer getCurrentBuffer() {
        return this.subDeserializer.getCurrentBuffer();
    }

    @Override
    public RecordDeserializer.DeserializationResult getNextRecord(T target) throws IOException {
        if (this.innerDeserializationResult == RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER) {
            this.innerDeserializationResult = this.innerDeserializer.getNextRecord(target);
        } else if (this.innerDeserializationResult == RecordDeserializer.DeserializationResult.LAST_RECORD_FROM_BUFFER) {
            this.innerDeserializationResult = RecordDeserializer.DeserializationResult.PARTIAL_RECORD;
        }
        if (this.innerDeserializationResult.isFullRecord()) {
            if (this.innerDeserializationResult == RecordDeserializer.DeserializationResult.LAST_RECORD_FROM_BUFFER && this.subDeserializationResult == RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER) {
                this.subDeserializationDelegate.reset();
                this.subDeserializationResult = this.subDeserializer.getNextRecord(this.subDeserializationDelegate);
                if (this.subDeserializationResult.isFullRecord()) {
                    this.innerDeserializer.setNextBuffer(this.subDeserializationDelegate.getBuffer());
                    this.innerDeserializationResult = RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER;
                }
            }
            if (this.innerDeserializationResult == RecordDeserializer.DeserializationResult.LAST_RECORD_FROM_BUFFER && this.subDeserializationResult == RecordDeserializer.DeserializationResult.LAST_RECORD_FROM_BUFFER) {
                return RecordDeserializer.DeserializationResult.LAST_RECORD_FROM_BUFFER;
            }
            return RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER;
        }
        while (this.innerDeserializationResult != RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER && this.subDeserializationResult == RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER) {
            this.subDeserializationDelegate.reset();
            this.subDeserializationResult = this.subDeserializer.getNextRecord(this.subDeserializationDelegate);
            if (!this.subDeserializationResult.isFullRecord()) break;
            this.innerDeserializer.setNextBuffer(this.subDeserializationDelegate.getBuffer());
            if (!this.innerDeserializationResult.isFullRecord()) {
                this.innerDeserializationResult = this.innerDeserializer.getNextRecord(target);
                continue;
            }
            this.innerDeserializationResult = RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER;
            break;
        }
        if (this.innerDeserializationResult.isFullRecord()) {
            if (!this.innerDeserializationResult.isBufferConsumed() || this.subDeserializationResult != RecordDeserializer.DeserializationResult.LAST_RECORD_FROM_BUFFER) {
                return RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER;
            }
            return RecordDeserializer.DeserializationResult.LAST_RECORD_FROM_BUFFER;
        }
        return RecordDeserializer.DeserializationResult.PARTIAL_RECORD;
    }

    @Override
    public void clear() {
        this.innerDeserializer.clear();
        this.innerDeserializationResult = RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER;
        this.subDeserializer.clear();
        this.subDeserializationDelegate.clear();
        this.subDeserializationResult = RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER;
    }

    @Override
    public boolean hasUnfinishedData() {
        return this.innerDeserializer.hasUnfinishedData() || this.subDeserializer.hasUnfinishedData();
    }
}

