/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.api.common.io.blockcompression.AbstractBlockCompressor;
import org.apache.flink.api.common.io.blockcompression.BlockCompressionFactory;
import org.apache.flink.api.common.io.blockcompression.InsufficientBufferException;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.network.api.serialization.BufferSerializationDelegate;
import org.apache.flink.runtime.io.network.api.serialization.ResizableBuffer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CompressionBufferTransformer
implements BufferSerializationDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(CompressionBufferTransformer.class);
    private AbstractBlockCompressor compressor;
    private ByteBuffer bufferToBeCompressed;
    private ResizableBuffer bufferWrapper;

    CompressionBufferTransformer(BlockCompressionFactory blockCompressionFactory) {
        this.compressor = blockCompressionFactory.getCompressor();
    }

    @Override
    public void setBuffer(ByteBuffer buffer) {
        this.bufferToBeCompressed = buffer;
    }

    @Override
    public void clear() {
        this.bufferToBeCompressed = null;
        if (this.bufferWrapper != null) {
            this.bufferWrapper.clear();
        }
    }

    public void write(DataOutputView out) throws IOException {
        ByteBuffer inputByteBuffer = this.bufferToBeCompressed;
        int prevInputPosition = inputByteBuffer.position();
        int lengthBeforeCompression = inputByteBuffer.remaining();
        int maxCompressedLen = this.compressor.getMaxCompressedSize(lengthBeforeCompression) + 8;
        if (out instanceof DataOutputSerializer) {
            int lengthAfterCompression;
            ByteBuffer outputByteBuffer;
            DataOutputSerializer dataOutputSerializer = (DataOutputSerializer)out;
            int prevOutputPosition = dataOutputSerializer.position();
            try {
                dataOutputSerializer.ensureCapacity(prevOutputPosition + maxCompressedLen);
                outputByteBuffer = ((DataOutputSerializer)out).wrapAsWritableByteBuffer();
                outputByteBuffer.position(prevOutputPosition + 8);
                lengthAfterCompression = this.compressor.compress(inputByteBuffer, outputByteBuffer);
            }
            catch (InsufficientBufferException e) {
                LOG.warn("Compressed buffer is larger than the original size, original buffer size " + lengthBeforeCompression);
                inputByteBuffer.position(prevInputPosition);
                dataOutputSerializer.ensureCapacity(prevOutputPosition + maxCompressedLen + (maxCompressedLen >> 1));
                outputByteBuffer = ((DataOutputSerializer)out).wrapAsWritableByteBuffer();
                outputByteBuffer.position(prevOutputPosition + 8);
                lengthAfterCompression = this.compressor.compress(inputByteBuffer, outputByteBuffer);
            }
            assert (outputByteBuffer.position() == prevOutputPosition + lengthAfterCompression + 8);
            outputByteBuffer.position(prevOutputPosition);
            outputByteBuffer.putInt(lengthAfterCompression);
            outputByteBuffer.putInt(lengthBeforeCompression);
            dataOutputSerializer.position(prevOutputPosition + lengthAfterCompression + 8);
        } else {
            int lengthAfterCompression;
            ByteBuffer outputByteBuffer;
            try {
                if (this.bufferWrapper == null) {
                    this.bufferWrapper = new ResizableBuffer();
                }
                this.bufferWrapper.resetCapacity(maxCompressedLen);
                outputByteBuffer = ByteBuffer.wrap(this.bufferWrapper.getHeapMemory());
                outputByteBuffer.position(8);
                lengthAfterCompression = this.compressor.compress(inputByteBuffer, outputByteBuffer);
            }
            catch (InsufficientBufferException e) {
                LOG.warn("Compressed buffer is larger than the original size, original buffer size " + lengthBeforeCompression);
                inputByteBuffer.position(prevInputPosition);
                this.bufferWrapper.resetCapacity(maxCompressedLen + (maxCompressedLen >> 1));
                outputByteBuffer = ByteBuffer.wrap(this.bufferWrapper.getHeapMemory());
                outputByteBuffer.position(8);
                lengthAfterCompression = this.compressor.compress(inputByteBuffer, outputByteBuffer);
            }
            assert (outputByteBuffer.position() == lengthAfterCompression + 8);
            outputByteBuffer.position(0);
            outputByteBuffer.putInt(lengthAfterCompression);
            outputByteBuffer.putInt(lengthBeforeCompression);
            Buffer currBuffer = this.bufferWrapper.getBuffer();
            currBuffer.setReaderIndex(0);
            currBuffer.setSize(lengthAfterCompression + 8);
            out.write(currBuffer.getMemorySegment(), currBuffer.getReaderIndex(), currBuffer.getSize());
            this.bufferWrapper.recycle();
        }
        this.bufferToBeCompressed = null;
    }
}

