/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.api.common.io.blockcompression.AbstractBlockDecompressor;
import org.apache.flink.api.common.io.blockcompression.BlockCompressionFactory;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.io.network.api.serialization.BufferDeserializationDelegate;
import org.apache.flink.runtime.io.network.api.serialization.NonSpanningWrapper;
import org.apache.flink.runtime.io.network.api.serialization.ResizableBuffer;
import org.apache.flink.runtime.io.network.buffer.Buffer;

final class DecompressionBufferTransformer
implements BufferDeserializationDelegate {
    private final AbstractBlockDecompressor decompressor;
    private final ResizableBuffer bufferWrapper;

    DecompressionBufferTransformer(BlockCompressionFactory blockCompressionFactory) {
        this.decompressor = blockCompressionFactory.getDecompressor();
        this.bufferWrapper = new ResizableBuffer();
    }

    @Override
    public void reset() {
        this.bufferWrapper.recycle();
    }

    @Override
    public Buffer getBuffer() {
        return this.bufferWrapper.getBuffer();
    }

    @Override
    public void clear() {
        this.bufferWrapper.clear();
    }

    public void read(DataInputView in) throws IOException {
        ByteBuffer inputByteBuffer;
        int lengthBeforeDecompression = in.readInt();
        int lengthAfterDecompression = in.readInt();
        this.bufferWrapper.resetCapacity(lengthAfterDecompression);
        ByteBuffer outputByteBuffer = ByteBuffer.wrap(this.bufferWrapper.getHeapMemory());
        if (in instanceof NonSpanningWrapper) {
            inputByteBuffer = ((NonSpanningWrapper)in).wrapAsByteBuffer(lengthBeforeDecompression);
        } else if (in instanceof DataInputDeserializer) {
            inputByteBuffer = ((DataInputDeserializer)in).wrapAsByteBuffer(lengthBeforeDecompression);
        } else {
            byte[] bytes = new byte[lengthBeforeDecompression];
            in.readFully(bytes, 0, lengthBeforeDecompression);
            inputByteBuffer = ByteBuffer.wrap(bytes);
        }
        this.decompressor.decompress(inputByteBuffer, outputByteBuffer);
        assert (outputByteBuffer.position() == lengthAfterDecompression);
        Buffer currentBuffer = this.bufferWrapper.getBuffer();
        currentBuffer.setReaderIndex(0);
        currentBuffer.setSize(lengthAfterDecompression);
        if (in instanceof NonSpanningWrapper) {
            in.skipBytesToRead(lengthBeforeDecompression);
        } else if (in instanceof DataInputDeserializer) {
            in.skipBytesToRead(lengthBeforeDecompression);
        }
    }
}

