/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;

final class NonSpanningWrapper
implements DataInputView {
    protected MemorySegment segment;
    private int limit;
    protected int position;
    private byte[] utfByteBuffer;
    private char[] utfCharBuffer;

    NonSpanningWrapper() {
    }

    int remaining() {
        return this.limit - this.position;
    }

    void clear() {
        this.segment = null;
        this.limit = 0;
        this.position = 0;
    }

    void initializeFromMemorySegment(MemorySegment seg, int position, int leftOverLimit) {
        this.segment = seg;
        this.position = position;
        this.limit = leftOverLimit;
    }

    ByteBuffer wrapAsByteBuffer(int length) {
        if (length <= this.limit - this.position) {
            return this.segment.wrap(this.position, length);
        }
        throw new IllegalArgumentException("require more than remaining bytes, required length: " + length + ", bytes left: " + (this.limit - this.position));
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        this.segment.get(this.position, b, off, len);
        this.position += len;
    }

    public final boolean readBoolean() throws IOException {
        return this.readByte() == 1;
    }

    public final byte readByte() throws IOException {
        return this.segment.get(this.position++);
    }

    public final int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public final short readShort() throws IOException {
        short v = this.segment.getShortBigEndian(this.position);
        this.position += 2;
        return v;
    }

    public final int readUnsignedShort() throws IOException {
        int v = this.segment.getShortBigEndian(this.position) & 0xFFFF;
        this.position += 2;
        return v;
    }

    public final char readChar() throws IOException {
        char v = this.segment.getCharBigEndian(this.position);
        this.position += 2;
        return v;
    }

    public final int readInt() throws IOException {
        int v = this.segment.getIntBigEndian(this.position);
        this.position += 4;
        return v;
    }

    public final long readLong() throws IOException {
        long v = this.segment.getLongBigEndian(this.position);
        this.position += 8;
        return v;
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readLine() throws IOException {
        StringBuilder bld = new StringBuilder(32);
        try {
            int b;
            while ((b = this.readUnsignedByte()) != 10) {
                if (b == 13) continue;
                bld.append((char)b);
            }
        }
        catch (EOFException b) {
            // empty catch block
        }
        if (bld.length() == 0) {
            return null;
        }
        int len = bld.length();
        if (len > 0 && bld.charAt(len - 1) == '\r') {
            bld.setLength(len - 1);
        }
        return bld.toString();
    }

    public final String readUTF() throws IOException {
        int c;
        int count;
        char[] chararr;
        byte[] bytearr;
        int utflen = this.readUnsignedShort();
        if (this.utfByteBuffer == null || this.utfByteBuffer.length < utflen) {
            bytearr = new byte[utflen];
            this.utfByteBuffer = bytearr;
        } else {
            bytearr = this.utfByteBuffer;
        }
        if (this.utfCharBuffer == null || this.utfCharBuffer.length < utflen) {
            chararr = new char[utflen];
            this.utfCharBuffer = chararr;
        } else {
            chararr = this.utfCharBuffer;
        }
        int chararrCount = 0;
        this.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararrCount++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararrCount++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararrCount++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararrCount++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararrCount);
    }

    public final int skipBytes(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int toSkip = Math.min(n, this.remaining());
        this.position += toSkip;
        return toSkip;
    }

    public void skipBytesToRead(int numBytes) throws IOException {
        int skippedBytes = this.skipBytes(numBytes);
        if (skippedBytes < numBytes) {
            throw new EOFException("Could not skip " + numBytes + " bytes.");
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("Byte array b cannot be null.");
        }
        if (off < 0) {
            throw new IllegalArgumentException("The offset off cannot be negative.");
        }
        if (len < 0) {
            throw new IllegalArgumentException("The length len cannot be negative.");
        }
        int toRead = Math.min(len, this.remaining());
        this.segment.get(this.position, b, off, toRead);
        this.position += toRead;
        return toRead;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

