/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;

public interface RecordSerializer<T extends IOReadableWritable> {
    public void serializeRecord(T var1) throws IOException;

    public SerializationResult copyToBufferBuilder(BufferBuilder var1);

    public SerializationResult flushToBufferBuilder(BufferBuilder var1);

    public void prune();

    public void reset();

    public boolean hasSerializedData();

    public static enum SerializationResult {
        PARTIAL_RECORD_MEMORY_SEGMENT_FULL(false, true),
        FULL_RECORD_MEMORY_SEGMENT_FULL(true, true),
        FULL_RECORD(true, false);

        private final boolean isFullRecord;
        private final boolean isFullBuffer;

        private SerializationResult(boolean isFullRecord, boolean isFullBuffer) {
            this.isFullRecord = isFullRecord;
            this.isFullBuffer = isFullBuffer;
        }

        public boolean isFullRecord() {
            return this.isFullRecord;
        }

        public boolean isFullBuffer() {
            return this.isFullBuffer;
        }
    }
}

