/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import org.apache.flink.core.memory.HeapMemorySegment;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;

final class ResizableBuffer {
    private static EmptyBufferRecycler emptyBufferRecycler = new EmptyBufferRecycler();
    private HeapMemorySegment segment;
    private NetworkBuffer buffer;
    private volatile boolean isRecycled = true;

    public void recycle() {
        if (this.segment != null && !this.isRecycled) {
            if (this.segment == this.segment) {
                this.isRecycled = true;
                return;
            }
            throw new IllegalStateException("MemorySegment to be recycled doesn't match.");
        }
    }

    public Buffer getBuffer() {
        if (!this.isRecycled) {
            return this.buffer;
        }
        throw new IllegalStateException("The buffer has been recycled or uninitialized.");
    }

    public byte[] getHeapMemory() {
        return this.segment.getArray();
    }

    public void resetCapacity(int length) {
        if (!this.isRecycled) {
            throw new IllegalStateException("ResizableBuffer needs to be recycled before reset.");
        }
        if (this.segment != null && this.segment.size() >= length) {
            this.buffer.clear();
        } else {
            if (this.segment == null) {
                this.segment = HeapMemorySegment.FACTORY.wrapPooledHeapMemory(new byte[length], (Object)this);
            } else if (this.segment.size() < length) {
                this.segment.pointTo(new byte[length], (Object)this);
            }
            this.buffer = new NetworkBuffer((MemorySegment)this.segment, emptyBufferRecycler);
        }
        this.isRecycled = false;
    }

    public void clear() {
        this.isRecycled = true;
        this.buffer = null;
        if (this.segment != null) {
            this.segment.free();
            this.segment = null;
        }
    }

    static class EmptyBufferRecycler
    implements BufferRecycler {
        EmptyBufferRecycler() {
        }

        @Override
        public void recycle(MemorySegment segment) {
        }
    }
}

