/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.SerializerManager;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;

public class SerializerManagerUtility<T extends IOReadableWritable> {
    private final Configuration configuration;
    private final Map<SingleInputGate, SerializerManager<T>> inputGateSerializerManagerMap;
    private SingleInputGate prevInputGate;
    private SerializerManager<T> prevSerializerManager;

    public SerializerManagerUtility(Configuration configuration) {
        this.configuration = configuration;
        this.inputGateSerializerManagerMap = new HashMap<SingleInputGate, SerializerManager<T>>();
    }

    public RecordDeserializer<T>[] createRecordDeserializers(InputChannel[] inputChannels, String[] tmpDirectories) {
        RecordDeserializer[] recordDeserializers = new RecordDeserializer[inputChannels.length];
        for (int i = 0; i < inputChannels.length; ++i) {
            recordDeserializers[i] = this.getOrCreateSerializerManager(inputChannels[i]).getRecordDeserializer(tmpDirectories);
        }
        this.clear();
        return recordDeserializers;
    }

    private final SerializerManager<T> getOrCreateSerializerManager(InputChannel inputChannel) {
        SingleInputGate currentInputGate = inputChannel.getInputGate();
        if (this.prevInputGate == currentInputGate) {
            return this.prevSerializerManager;
        }
        SerializerManager<T> currentSerializerManager = this.inputGateSerializerManagerMap.get(currentInputGate);
        if (currentSerializerManager == null) {
            currentSerializerManager = new SerializerManager(currentInputGate, this.configuration);
            this.inputGateSerializerManagerMap.put(currentInputGate, currentSerializerManager);
        }
        this.prevInputGate = currentInputGate;
        this.prevSerializerManager = currentSerializerManager;
        return currentSerializerManager;
    }

    private final void clear() {
        this.prevInputGate = null;
        this.prevSerializerManager = null;
        this.inputGateSerializerManagerMap.clear();
    }
}

