/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.api.serialization.NonSpanningWrapper;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.SpanningWrapper;
import org.apache.flink.runtime.io.network.buffer.Buffer;

public class SpillingAdaptiveSpanningRecordDeserializer<T extends IOReadableWritable>
implements RecordDeserializer<T> {
    private static final String BROKEN_SERIALIZATION_ERROR_MESSAGE = "Serializer consumed more bytes than the record had. This indicates broken serialization. If you are using custom serialization types (Value or Writable), check their serialization methods. If you are using a Kryo-serialized type, check the corresponding Kryo serializer.";
    private final NonSpanningWrapper nonSpanningWrapper = new NonSpanningWrapper();
    private final SpanningWrapper spanningWrapper;
    private Buffer currentBuffer;

    public SpillingAdaptiveSpanningRecordDeserializer(String[] tmpDirectories) {
        this.spanningWrapper = new SpanningWrapper(tmpDirectories);
    }

    @Override
    public void setNextBuffer(Buffer buffer) throws IOException {
        this.currentBuffer = buffer;
        int offset = buffer.getMemorySegmentOffset();
        MemorySegment segment = buffer.getMemorySegment();
        int numBytes = buffer.getSize();
        if (this.spanningWrapper.getNumGatheredBytes() > 0) {
            this.spanningWrapper.addNextChunkFromMemorySegment(segment, offset, numBytes);
        } else {
            this.nonSpanningWrapper.initializeFromMemorySegment(segment, offset, numBytes + offset);
        }
    }

    @Override
    public Buffer getCurrentBuffer() {
        Buffer tmp = this.currentBuffer;
        this.currentBuffer = null;
        return tmp;
    }

    @Override
    public RecordDeserializer.DeserializationResult getNextRecord(T target) throws IOException {
        int nonSpanningRemaining = this.nonSpanningWrapper.remaining();
        if (nonSpanningRemaining >= 4) {
            int len = this.nonSpanningWrapper.readInt();
            if (len <= nonSpanningRemaining - 4) {
                try {
                    target.read((DataInputView)this.nonSpanningWrapper);
                    int remaining = this.nonSpanningWrapper.remaining();
                    if (remaining > 0) {
                        return RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER;
                    }
                    if (remaining == 0) {
                        return RecordDeserializer.DeserializationResult.LAST_RECORD_FROM_BUFFER;
                    }
                    throw new IndexOutOfBoundsException("Remaining = " + remaining);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new IOException(BROKEN_SERIALIZATION_ERROR_MESSAGE, e);
                }
            }
            this.spanningWrapper.initializeWithPartialRecord(this.nonSpanningWrapper, len);
            this.nonSpanningWrapper.clear();
            return RecordDeserializer.DeserializationResult.PARTIAL_RECORD;
        }
        if (nonSpanningRemaining > 0) {
            this.spanningWrapper.initializeWithPartialLength(this.nonSpanningWrapper);
            this.nonSpanningWrapper.clear();
            return RecordDeserializer.DeserializationResult.PARTIAL_RECORD;
        }
        if (this.spanningWrapper.hasFullRecord()) {
            target.read(this.spanningWrapper.getInputView());
            this.spanningWrapper.moveRemainderToNonSpanningDeserializer(this.nonSpanningWrapper);
            this.spanningWrapper.clear();
            return this.nonSpanningWrapper.remaining() == 0 ? RecordDeserializer.DeserializationResult.LAST_RECORD_FROM_BUFFER : RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER;
        }
        return RecordDeserializer.DeserializationResult.PARTIAL_RECORD;
    }

    @Override
    public void clear() {
        this.nonSpanningWrapper.clear();
        this.spanningWrapper.clear();
    }

    @Override
    public boolean hasUnfinishedData() {
        return this.nonSpanningWrapper.remaining() > 0 || this.spanningWrapper.getNumGatheredBytes() > 0;
    }
}

