/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.writer.ChannelSelector;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.api.writer.RoundRobinChannelSelector;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.util.XORShiftRandom;

public class RecordWriter<T> {
    protected final ResultPartitionWriter targetPartition;
    private final ChannelSelector<T> channelSelector;
    private final int[] allChannels;
    private final int numChannels;
    private final Random rng = new XORShiftRandom();
    private final boolean flushAlways;
    private final boolean isBroadcastSelector;

    public RecordWriter(ResultPartitionWriter writer) {
        this(writer, new RoundRobinChannelSelector(), false);
    }

    public RecordWriter(ResultPartitionWriter writer, ChannelSelector<T> channelSelector, boolean isBroadcastSelector) {
        this(writer, channelSelector, isBroadcastSelector, false);
    }

    public RecordWriter(ResultPartitionWriter writer, ChannelSelector<T> channelSelector, boolean isBroadcastSelector, boolean flushAlways) {
        this.isBroadcastSelector = isBroadcastSelector;
        this.flushAlways = flushAlways;
        this.targetPartition = writer;
        this.channelSelector = channelSelector;
        this.numChannels = writer.getNumberOfSubpartitions();
        this.allChannels = new int[this.numChannels];
        for (int i = 0; i < this.numChannels; ++i) {
            this.allChannels[i] = i;
        }
    }

    public void emit(T record) throws IOException, InterruptedException {
        if (this.isBroadcastSelector) {
            this.targetPartition.emitRecord(record, this.allChannels, this.isBroadcastSelector, this.flushAlways);
        } else {
            int targetChannel = this.channelSelector.selectChannel(record, this.numChannels);
            this.targetPartition.emitRecord(record, targetChannel, this.isBroadcastSelector, this.flushAlways);
        }
    }

    public void broadcastEmit(T record) throws IOException, InterruptedException {
        this.targetPartition.emitRecord(record, this.allChannels, this.isBroadcastSelector, this.flushAlways);
    }

    public void randomEmit(T record) throws IOException, InterruptedException {
        int targetChannel = this.rng.nextInt(this.numChannels);
        this.targetPartition.emitRecord(record, targetChannel, this.isBroadcastSelector, this.flushAlways);
    }

    public void broadcastEvent(AbstractEvent event) throws IOException {
        this.targetPartition.broadcastEvent(event, this.flushAlways);
    }

    public void flushAll() {
        this.targetPartition.flushAll();
    }

    public void clearBuffers() {
        this.targetPartition.clearBuffers();
    }

    public void setMetricGroup(TaskIOMetricGroup metrics, boolean enableTracingMetrics, int tracingMetricsInterval) {
        this.targetPartition.setMetricGroup(metrics, enableTracingMetrics, tracingMetricsInterval);
    }
}

