/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.netty.CreditBasedPartitionRequestClientHandler;
import org.apache.flink.runtime.io.network.netty.NetworkBufferAllocator;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.util.Preconditions;

public class CreditedBasedReceiverSideNetworkBufferAllocator
implements NetworkBufferAllocator {
    private final CreditBasedPartitionRequestClientHandler partitionRequestClientHandler;

    CreditedBasedReceiverSideNetworkBufferAllocator(CreditBasedPartitionRequestClientHandler partitionRequestClientHandler) {
        this.partitionRequestClientHandler = (CreditBasedPartitionRequestClientHandler)Preconditions.checkNotNull((Object)partitionRequestClientHandler);
    }

    @Override
    public Buffer allocatePooledNetworkBuffer(InputChannelID receiverId, int size) {
        Buffer buffer = null;
        RemoteInputChannel inputChannel = this.partitionRequestClientHandler.getInputChannel(receiverId);
        if (inputChannel != null) {
            buffer = inputChannel.requestBuffer();
        }
        return buffer;
    }

    @Override
    public Buffer allocateUnPooledNetworkBuffer(int size) {
        byte[] byteArray = new byte[size];
        MemorySegment memSeg = MemorySegmentFactory.wrap((byte[])byteArray);
        return new NetworkBuffer(memSeg, FreeingBufferRecycler.INSTANCE, false);
    }
}

