/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.netty.CreditBasedPartitionRequestClientHandler;
import org.apache.flink.runtime.io.network.netty.CreditedBasedReceiverSideNetworkBufferAllocator;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.netty.PartitionRequestClientHandler;
import org.apache.flink.runtime.io.network.netty.PartitionRequestQueue;
import org.apache.flink.runtime.io.network.netty.PartitionRequestServerHandler;
import org.apache.flink.runtime.io.network.netty.ZeroCopyNettyMessageDecoder;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;

public class NettyProtocol {
    private final NettyMessage.NettyMessageEncoder messageEncoder = new NettyMessage.NettyMessageEncoder();
    private final NettyMessage.NettyMessageDecoder messageDecoder = new NettyMessage.NettyMessageDecoder();
    private final ResultPartitionProvider partitionProvider;
    private final TaskEventDispatcher taskEventDispatcher;
    private final boolean creditBasedEnabled;

    public NettyProtocol(ResultPartitionProvider partitionProvider, TaskEventDispatcher taskEventDispatcher, boolean creditBasedEnabled) {
        this.partitionProvider = partitionProvider;
        this.taskEventDispatcher = taskEventDispatcher;
        this.creditBasedEnabled = creditBasedEnabled;
    }

    public ChannelHandler[] getServerChannelHandlers() {
        PartitionRequestQueue queueOfPartitionQueues = new PartitionRequestQueue();
        PartitionRequestServerHandler serverHandler = new PartitionRequestServerHandler(this.partitionProvider, this.taskEventDispatcher, queueOfPartitionQueues, this.creditBasedEnabled);
        return new ChannelHandler[]{this.messageEncoder, new ZeroCopyNettyMessageDecoder(null), serverHandler, queueOfPartitionQueues};
    }

    public ChannelHandler[] getClientChannelHandlers() {
        if (this.creditBasedEnabled) {
            CreditBasedPartitionRequestClientHandler networkClientHandler = new CreditBasedPartitionRequestClientHandler();
            CreditedBasedReceiverSideNetworkBufferAllocator networkBufferAllocator = new CreditedBasedReceiverSideNetworkBufferAllocator(networkClientHandler);
            ZeroCopyNettyMessageDecoder zeroCopyMessageDecoder = new ZeroCopyNettyMessageDecoder(networkBufferAllocator);
            return new ChannelHandler[]{this.messageEncoder, zeroCopyMessageDecoder, networkClientHandler};
        }
        PartitionRequestClientHandler networkClientHandler = new PartitionRequestClientHandler();
        return new ChannelHandler[]{this.messageEncoder, NettyMessage.NettyMessageEncoder.createFrameLengthDecoder(), this.messageDecoder, networkClientHandler};
    }
}

