/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.api.serialization.RecordSerializer;
import org.apache.flink.runtime.io.network.api.serialization.SpanningRecordSerializer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferPoolOwner;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionConsumableNotifier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.SpillableSubpartition;
import org.apache.flink.runtime.metrics.SumAndCount;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.runtime.taskmanager.TaskActions;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalResultPartition<T>
extends ResultPartition<T>
implements BufferPoolOwner {
    private static final Logger LOG = LoggerFactory.getLogger(InternalResultPartition.class);
    private final TaskActions taskActions;
    private final RecordSerializer serializer;
    private final Optional<BufferBuilder>[] bufferBuilders;
    private final ResultSubpartition[] subpartitions;
    private final ResultPartitionManager partitionManager;
    private final ResultPartitionConsumableNotifier partitionConsumableNotifier;
    private final boolean sendScheduleOrUpdateConsumersMessage;
    private final AtomicInteger pendingReferences = new AtomicInteger();
    private BufferPool bufferPool;
    private boolean hasNotifiedPipelinedConsumers;
    private boolean enableTracingMetrics;
    private int tracingMetricsInterval;
    private long resultCounter = 0L;
    private SumAndCount nsWaitBufferTime;
    private boolean traceTriggered = false;
    private long waitOutputForCurrentRecord = 0L;
    private Counter numRecordsSent;

    public InternalResultPartition(String owningTaskName, TaskActions taskActions, JobID jobId, ResultPartitionID partitionId, ResultPartitionType partitionType, int numberOfSubpartitions, int numTargetKeyGroups, ResultPartitionManager partitionManager, ResultPartitionConsumableNotifier partitionConsumableNotifier, IOManager ioManager, boolean sendScheduleOrUpdateConsumersMessage) {
        super(owningTaskName, jobId, partitionId, partitionType, numberOfSubpartitions, numTargetKeyGroups);
        int i;
        this.taskActions = (TaskActions)Preconditions.checkNotNull((Object)taskActions);
        this.subpartitions = new ResultSubpartition[numberOfSubpartitions];
        this.partitionManager = (ResultPartitionManager)Preconditions.checkNotNull((Object)partitionManager);
        this.partitionConsumableNotifier = (ResultPartitionConsumableNotifier)Preconditions.checkNotNull((Object)partitionConsumableNotifier);
        this.sendScheduleOrUpdateConsumersMessage = sendScheduleOrUpdateConsumersMessage;
        this.serializer = new SpanningRecordSerializer();
        this.bufferBuilders = new Optional[numberOfSubpartitions];
        for (i = 0; i < numberOfSubpartitions; ++i) {
            this.bufferBuilders[i] = Optional.empty();
        }
        switch (partitionType) {
            case BLOCKING: {
                for (i = 0; i < this.subpartitions.length; ++i) {
                    this.subpartitions[i] = new SpillableSubpartition(i, this, ioManager);
                }
                break;
            }
            case PIPELINED: {
                for (i = 0; i < this.subpartitions.length; ++i) {
                    this.subpartitions[i] = new PipelinedSubpartition(i, this);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported result partition type.");
            }
        }
        this.pin();
        LOG.debug("{}: Initialized {}", (Object)owningTaskName, (Object)this);
    }

    public void registerBufferPool(BufferPool bufferPool) {
        Preconditions.checkArgument((bufferPool.getNumberOfRequiredMemorySegments() >= this.getNumberOfSubpartitions() ? 1 : 0) != 0, (Object)"Bug in result partition setup logic: Buffer pool has not enough guaranteed buffers for this result partition.");
        Preconditions.checkState((this.bufferPool == null ? 1 : 0) != 0, (Object)"Bug in result partition setup logic: Already registered buffer pool.");
        this.bufferPool = (BufferPool)Preconditions.checkNotNull((Object)bufferPool);
        if (!this.partitionType.hasBackPressure()) {
            bufferPool.setBufferPoolOwner(this);
        }
    }

    @VisibleForTesting
    public BufferProvider getBufferProvider() {
        return this.bufferPool;
    }

    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public int getNumberOfQueuedBuffers() {
        int totalBuffers = 0;
        for (ResultSubpartition subpartition : this.subpartitions) {
            totalBuffers += subpartition.unsynchronizedGetNumberOfQueuedBuffers();
        }
        return totalBuffers;
    }

    public boolean getHasNotifiedPipelinedConsumers() {
        return this.hasNotifiedPipelinedConsumers;
    }

    @Override
    public void emitRecord(T record, int[] targetChannels, boolean isBroadcast, boolean flushAlways) throws IOException, InterruptedException {
        this.serializationDelegate.setInstance(record);
        this.serializer.serializeRecord(this.serializationDelegate);
        this.beginTracing();
        boolean pruneAfterCopying = false;
        if (isBroadcast) {
            pruneAfterCopying = this.copyFromSerializerToTargetChannel(0, true, flushAlways);
        } else {
            for (int channel : targetChannels) {
                if (!this.copyFromSerializerToTargetChannel(channel, false, flushAlways)) continue;
                pruneAfterCopying = true;
            }
        }
        if (pruneAfterCopying) {
            this.serializer.prune();
        }
        if (isBroadcast) {
            this.endTracing(this.subpartitions.length);
        } else {
            this.endTracing(targetChannels.length);
        }
    }

    @Override
    public void emitRecord(T record, int targetChannel, boolean isBroadcast, boolean flushAlways) throws IOException, InterruptedException {
        this.serializationDelegate.setInstance(record);
        this.serializer.serializeRecord(this.serializationDelegate);
        this.beginTracing();
        if (isBroadcast) {
            this.tryFinishCurrentBufferBuilder(targetChannel, true);
        }
        if (this.copyFromSerializerToTargetChannel(targetChannel, isBroadcast, flushAlways)) {
            this.serializer.prune();
        }
        if (isBroadcast) {
            this.tryFinishCurrentBufferBuilder(targetChannel, true);
        }
        if (isBroadcast) {
            this.endTracing(this.subpartitions.length);
        } else {
            this.endTracing(1L);
        }
    }

    @Override
    public void broadcastEvent(AbstractEvent event, boolean flushAlways) throws IOException {
        try (BufferConsumer eventBufferConsumer = EventSerializer.toBufferConsumer(event);){
            for (int targetChannel = 0; targetChannel < this.numberOfSubpartitions; ++targetChannel) {
                this.tryFinishCurrentBufferBuilder(targetChannel, false);
                this.addBufferConsumer(eventBufferConsumer.copy(), targetChannel);
            }
            if (flushAlways) {
                this.flushAll();
            }
        }
    }

    @VisibleForTesting
    public void addBufferConsumer(BufferConsumer bufferConsumer, int subpartitionIndex) throws IOException {
        ResultSubpartition subpartition;
        Preconditions.checkNotNull((Object)bufferConsumer);
        try {
            this.checkInProduceState();
            subpartition = this.subpartitions[subpartitionIndex];
        }
        catch (Exception ex) {
            bufferConsumer.close();
            throw ex;
        }
        if (subpartition.add(bufferConsumer)) {
            this.notifyPipelinedConsumers();
        }
    }

    @Override
    public void flushAll() {
        for (ResultSubpartition subpartition : this.subpartitions) {
            subpartition.flush();
        }
    }

    @Override
    public void flush(int subpartitionIndex) {
        this.subpartitions[subpartitionIndex].flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() throws IOException {
        boolean success = false;
        try {
            this.checkInProduceState();
            for (ResultSubpartition subpartition : this.subpartitions) {
                subpartition.finish();
            }
            success = true;
        }
        finally {
            if (success) {
                this.isFinished = true;
                this.notifyPipelinedConsumers();
            }
        }
    }

    public void destroyBufferPool() {
        if (this.bufferPool != null) {
            this.bufferPool.lazyDestroy();
        }
    }

    public ResultSubpartitionView createSubpartitionView(int index, BufferAvailabilityListener availabilityListener) throws IOException {
        int refCnt = this.pendingReferences.get();
        Preconditions.checkState((refCnt != -1 ? 1 : 0) != 0, (Object)"Partition released.");
        Preconditions.checkState((refCnt > 0 ? 1 : 0) != 0, (Object)"Partition not pinned.");
        Preconditions.checkElementIndex((int)index, (int)this.subpartitions.length, (String)"Subpartition not found.");
        ResultSubpartitionView readView = this.subpartitions[index].createReadView(availabilityListener);
        LOG.debug("Created {}", (Object)readView);
        return readView;
    }

    @Override
    protected void releaseInternal() {
        for (ResultSubpartition subpartition : this.subpartitions) {
            try {
                subpartition.release();
            }
            catch (Throwable t) {
                LOG.error("Error during release of result subpartition: " + t.getMessage(), t);
            }
        }
        if (this.partitionType == ResultPartitionType.BLOCKING && this.bufferPool != null) {
            this.bufferPool.notifyBufferPoolOwnerReleased();
        }
    }

    @Override
    public void releaseMemory(int toRelease) throws IOException {
        Preconditions.checkArgument((toRelease > 0 ? 1 : 0) != 0);
        for (ResultSubpartition subpartition : this.subpartitions) {
            if ((toRelease -= subpartition.releaseMemory()) <= 0) break;
        }
    }

    public String toString() {
        return "InternalResultPartition " + this.partitionId.toString() + " [" + (Object)((Object)this.partitionType) + ", " + this.subpartitions.length + " subpartitions, " + this.pendingReferences + " pending references]";
    }

    void pin() {
        block1: {
            int refCnt;
            while ((refCnt = this.pendingReferences.get()) >= 0) {
                if (!this.pendingReferences.compareAndSet(refCnt, refCnt + this.subpartitions.length)) continue;
                break block1;
            }
            throw new IllegalStateException("Released.");
        }
    }

    void onConsumedSubpartition(int subpartitionIndex) {
        if (this.isReleased.get()) {
            return;
        }
        int refCnt = this.pendingReferences.decrementAndGet();
        if (refCnt == 0) {
            this.partitionManager.onConsumedPartition(this);
        } else if (refCnt < 0) {
            throw new IllegalStateException("All references released.");
        }
        LOG.debug("{}: Received release notification for subpartition {} (reference count now at: {}).", new Object[]{this, subpartitionIndex, this.pendingReferences});
    }

    ResultSubpartition[] getAllPartitions() {
        return this.subpartitions;
    }

    private void notifyPipelinedConsumers() {
        if (this.sendScheduleOrUpdateConsumersMessage && !this.hasNotifiedPipelinedConsumers && this.partitionType.isPipelined()) {
            this.partitionConsumableNotifier.notifyPartitionConsumable(this.jobId, this.partitionId, this.taskActions);
            this.hasNotifiedPipelinedConsumers = true;
        }
    }

    @Nonnull
    private BufferBuilder requestNewBufferBuilder(int targetChannel, boolean isBroadcast) throws IOException, InterruptedException {
        BufferBuilder bufferBuilder;
        Preconditions.checkState((!this.bufferBuilders[targetChannel].isPresent() || this.bufferBuilders[targetChannel].get().isFinished() ? 1 : 0) != 0);
        if (this.traceTriggered) {
            long start2 = System.nanoTime();
            bufferBuilder = this.getBufferProvider().requestBufferBuilderBlocking();
            this.waitOutputForCurrentRecord += System.nanoTime() - start2;
        } else {
            bufferBuilder = this.getBufferProvider().requestBufferBuilderBlocking();
        }
        if (isBroadcast) {
            BufferConsumer bufferConsumer = bufferBuilder.createBufferConsumer();
            this.addBufferConsumer(bufferConsumer, 0);
            this.bufferBuilders[0] = Optional.of(bufferBuilder);
            for (int channel = 1; channel < this.numberOfSubpartitions; ++channel) {
                Preconditions.checkState((!this.bufferBuilders[channel].isPresent() || this.bufferBuilders[channel].get().isFinished() ? 1 : 0) != 0);
                this.addBufferConsumer(bufferConsumer.copy(), channel);
                this.bufferBuilders[channel] = Optional.of(bufferBuilder);
            }
        } else {
            this.addBufferConsumer(bufferBuilder.createBufferConsumer(), targetChannel);
            this.bufferBuilders[targetChannel] = Optional.of(bufferBuilder);
        }
        return bufferBuilder;
    }

    @Nonnull
    private BufferBuilder getBufferBuilder(int targetChannel, boolean isBroadcast) throws IOException, InterruptedException {
        if (this.bufferBuilders[targetChannel].isPresent() && !this.bufferBuilders[targetChannel].get().isFinished()) {
            return this.bufferBuilders[targetChannel].get();
        }
        return this.requestNewBufferBuilder(targetChannel, isBroadcast);
    }

    private void tryFinishCurrentBufferBuilder(int targetChannel, boolean isBroadcast) {
        if (!this.bufferBuilders[targetChannel].isPresent()) {
            return;
        }
        BufferBuilder bufferBuilder = this.bufferBuilders[targetChannel].get();
        this.updateMetrics(bufferBuilder, isBroadcast);
    }

    private void updateMetrics(BufferBuilder bufferBuilder, boolean isBroadcast) {
        if (isBroadcast) {
            this.numBytesOut.inc((long)bufferBuilder.finish() * (long)this.numberOfSubpartitions);
            this.numBuffersOut.inc((long)this.numberOfSubpartitions);
        } else {
            this.numBytesOut.inc((long)bufferBuilder.finish());
            this.numBuffersOut.inc();
        }
    }

    private boolean copyFromSerializerToTargetChannel(int targetChannel, boolean isBroadcast, boolean flushAlways) throws IOException, InterruptedException {
        this.serializer.reset();
        boolean pruneTriggered = false;
        BufferBuilder bufferBuilder = this.getBufferBuilder(targetChannel, isBroadcast);
        RecordSerializer.SerializationResult result = this.serializer.copyToBufferBuilder(bufferBuilder);
        while (result.isFullBuffer()) {
            this.updateMetrics(bufferBuilder, isBroadcast);
            if (result.isFullRecord()) {
                pruneTriggered = true;
                break;
            }
            bufferBuilder = this.requestNewBufferBuilder(targetChannel, isBroadcast);
            result = this.serializer.copyToBufferBuilder(bufferBuilder);
        }
        Preconditions.checkState((!this.serializer.hasSerializedData() ? 1 : 0) != 0, (Object)"All data should be written at once");
        if (flushAlways) {
            if (isBroadcast) {
                this.flushAll();
            } else {
                this.flush(targetChannel);
            }
        }
        return pruneTriggered;
    }

    private void closeBufferBuilder(int targetChannel) {
        if (this.bufferBuilders[targetChannel].isPresent()) {
            this.bufferBuilders[targetChannel].get().finish();
            this.bufferBuilders[targetChannel] = Optional.empty();
        }
    }

    @Override
    public void clearBuffers() {
        for (int targetChannel = 0; targetChannel < this.subpartitions.length; ++targetChannel) {
            this.closeBufferBuilder(targetChannel);
        }
    }

    @Override
    public void setTypeSerializer(TypeSerializer typeSerializer) {
        super.setTypeSerializer(typeSerializer);
        this.serializationDelegate = new SerializationDelegate(typeSerializer);
    }

    @Override
    public void setMetricGroup(TaskIOMetricGroup metrics, boolean enableTracingMetrics, int tracingMetricsInterval) {
        super.setMetricGroup(metrics, enableTracingMetrics, tracingMetricsInterval);
        this.numRecordsSent = metrics.getNumRecordsSent();
        this.enableTracingMetrics = enableTracingMetrics;
        this.tracingMetricsInterval = tracingMetricsInterval;
        if (enableTracingMetrics) {
            this.nsWaitBufferTime = metrics.getNsWaitBufferTime();
        }
    }

    private void beginTracing() {
        if (this.enableTracingMetrics && this.resultCounter++ % (long)this.tracingMetricsInterval == 0L) {
            this.traceTriggered = true;
            this.waitOutputForCurrentRecord = 0L;
        } else {
            this.traceTriggered = false;
        }
    }

    private void endTracing(long count) {
        if (this.traceTriggered) {
            this.nsWaitBufferTime.update(count, this.waitOutputForCurrentRecord);
        }
        if (this.numRecordsSent != null) {
            this.numRecordsSent.inc(count);
        }
    }
}

