/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.util.Preconditions;

public class PartitionRequestManager {
    private final Object lock = new Object();
    private final LinkedList<SingleInputGate> inputGates;
    @GuardedBy(value="lock")
    private final Map<SingleInputGate, LinkedList<RemoteInputChannel>> pendingPartitionRequests;
    @GuardedBy(value="lock")
    private final Map<SingleInputGate, Integer> reservedPartitionRequestQuota;
    @GuardedBy(value="lock")
    private final Map<SingleInputGate, Integer> currentUsedPartitionRequestQuota;
    private final int numInputs;
    private final int maxConcurrentPartitionRequests;
    @GuardedBy(value="lock")
    private int availableRequestQuota;
    private int numRegisteredInputGates;

    public PartitionRequestManager(int maxConcurrentPartitionRequests, int numInputs) {
        Preconditions.checkArgument((numInputs > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxConcurrentPartitionRequests >= numInputs ? 1 : 0) != 0);
        this.maxConcurrentPartitionRequests = maxConcurrentPartitionRequests;
        this.numInputs = numInputs;
        this.inputGates = new LinkedList();
        this.reservedPartitionRequestQuota = new HashMap<SingleInputGate, Integer>();
        this.currentUsedPartitionRequestQuota = new HashMap<SingleInputGate, Integer>();
        this.pendingPartitionRequests = new HashMap<SingleInputGate, LinkedList<RemoteInputChannel>>();
        this.availableRequestQuota = 0;
        this.numRegisteredInputGates = 0;
    }

    void registerSingleInputGate(SingleInputGate inputGate) {
        Preconditions.checkArgument((this.numRegisteredInputGates < this.numInputs ? 1 : 0) != 0, (Object)("Too many input gate registrations, input size: " + this.numInputs));
        if (inputGate.isPartitionRequestRestricted()) {
            this.inputGates.add(inputGate);
        }
        if (++this.numRegisteredInputGates == this.numInputs && this.inputGates.size() > 0) {
            Collections.shuffle(this.inputGates);
            this.distributePartitionRequestQuotasFairly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestPartitions(SingleInputGate inputGate) throws IOException, InterruptedException {
        Map<IntermediateResultPartitionID, InputChannel> inputChannels = inputGate.getInputChannels();
        int consumedSubpartitionIndex = inputGate.getConsumedSubpartitionIndex();
        if (!inputGate.isPartitionRequestRestricted()) {
            for (InputChannel inputChannel : inputChannels.values()) {
                this.internalRequestSubpartition(inputGate, inputChannel, consumedSubpartitionIndex);
            }
            return;
        }
        LinkedList<RemoteInputChannel> pendingChannelList = new LinkedList<RemoteInputChannel>();
        ArrayList<InputChannel> allInputChannels = new ArrayList<InputChannel>(inputChannels.values());
        Collections.shuffle(allInputChannels);
        Object object = this.lock;
        synchronized (object) {
            int remainingQuota = this.reservedPartitionRequestQuota.get(inputGate);
            int numberOfUsedQuota = 0;
            for (InputChannel inputChannel : allInputChannels) {
                if (!(inputChannel instanceof RemoteInputChannel)) {
                    this.internalRequestSubpartition(inputGate, inputChannel, consumedSubpartitionIndex);
                    continue;
                }
                if (remainingQuota > 0) {
                    this.internalRequestSubpartition(inputGate, inputChannel, consumedSubpartitionIndex);
                    --remainingQuota;
                    ++numberOfUsedQuota;
                    continue;
                }
                if (this.availableRequestQuota > 0) {
                    this.internalRequestSubpartition(inputGate, inputChannel, consumedSubpartitionIndex);
                    --this.availableRequestQuota;
                    ++numberOfUsedQuota;
                    continue;
                }
                pendingChannelList.addLast((RemoteInputChannel)inputChannel);
            }
            if (!pendingChannelList.isEmpty()) {
                this.pendingPartitionRequests.put(inputGate, pendingChannelList);
            }
            if (numberOfUsedQuota == 0) {
                this.availableRequestQuota += remainingQuota - 1;
                this.reservedPartitionRequestQuota.put(inputGate, 1);
            } else {
                this.availableRequestQuota += remainingQuota;
                this.reservedPartitionRequestQuota.put(inputGate, 0);
            }
            this.currentUsedPartitionRequestQuota.put(inputGate, numberOfUsedQuota);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onInputChannelFinish(SingleInputGate inputGate, InputChannel channel, boolean hasReceivedAllEndOfPartitionEvents) throws IOException, InterruptedException {
        if (!inputGate.isPartitionRequestRestricted() || !(channel instanceof RemoteInputChannel)) {
            return;
        }
        int consumedSubpartitionIndex = inputGate.getConsumedSubpartitionIndex();
        Object object = this.lock;
        synchronized (object) {
            RemoteInputChannel inputChannel = this.getPendingRemoteChannel(inputGate);
            if (inputChannel != null) {
                this.internalRequestSubpartition(inputGate, inputChannel, consumedSubpartitionIndex);
                return;
            }
            int currentUsedQuota = this.currentUsedPartitionRequestQuota.get(inputGate);
            this.currentUsedPartitionRequestQuota.put(inputGate, currentUsedQuota - 1);
            if (currentUsedQuota > 1 || hasReceivedAllEndOfPartitionEvents) {
                if (this.pendingPartitionRequests.size() > 0) {
                    for (int i = 0; i < this.inputGates.size(); ++i) {
                        SingleInputGate currentInputGate = this.inputGates.pollFirst();
                        this.inputGates.addLast(currentInputGate);
                        inputChannel = this.getPendingRemoteChannel(currentInputGate);
                        if (inputChannel == null) continue;
                        this.internalRequestSubpartition(inputGate, inputChannel, consumedSubpartitionIndex);
                        this.currentUsedPartitionRequestQuota.put(currentInputGate, this.currentUsedPartitionRequestQuota.get(currentInputGate) + 1);
                        break;
                    }
                } else {
                    ++this.availableRequestQuota;
                }
            } else if (currentUsedQuota == 1) {
                int reservedQuota = this.reservedPartitionRequestQuota.get(inputGate);
                Preconditions.checkState((reservedQuota == 0 ? 1 : 0) != 0, (Object)("The reserved quota must be 0, but actual is " + reservedQuota));
                this.reservedPartitionRequestQuota.put(inputGate, reservedQuota + 1);
            } else {
                throw new IllegalStateException("The current used quota should be never less than 1, but the actual value is " + currentUsedQuota);
            }
            if (hasReceivedAllEndOfPartitionEvents) {
                this.inputGates.remove(inputGate);
                this.pendingPartitionRequests.remove(inputGate);
                this.reservedPartitionRequestQuota.remove(inputGate);
                this.currentUsedPartitionRequestQuota.remove(inputGate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateInputChannel(SingleInputGate inputGate, InputChannel inputChannel) throws IOException, InterruptedException {
        int consumedSubpartitionIndex = inputGate.getConsumedSubpartitionIndex();
        if (!inputGate.isPartitionRequestRestricted() || !(inputChannel instanceof RemoteInputChannel)) {
            this.internalRequestSubpartition(inputGate, inputChannel, consumedSubpartitionIndex);
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            int currentUsedQuota = this.currentUsedPartitionRequestQuota.get(inputGate);
            int reservedQuota = this.reservedPartitionRequestQuota.get(inputGate);
            if (reservedQuota > 0) {
                Preconditions.checkState((reservedQuota == 1 ? 1 : 0) != 0, (Object)("The reserved quota must be 1, but actual is " + reservedQuota));
                this.internalRequestSubpartition(inputGate, inputChannel, consumedSubpartitionIndex);
                this.reservedPartitionRequestQuota.put(inputGate, reservedQuota - 1);
                this.currentUsedPartitionRequestQuota.put(inputGate, currentUsedQuota + 1);
            } else if (this.availableRequestQuota > 0) {
                this.internalRequestSubpartition(inputGate, inputChannel, consumedSubpartitionIndex);
                --this.availableRequestQuota;
                this.currentUsedPartitionRequestQuota.put(inputGate, currentUsedQuota + 1);
            } else {
                this.addPendingRemoteChannel(inputGate, (RemoteInputChannel)inputChannel);
            }
        }
    }

    private void distributePartitionRequestQuotasFairly() {
        int averageQuota = this.maxConcurrentPartitionRequests / this.inputGates.size();
        int remainingQuota = this.maxConcurrentPartitionRequests % this.inputGates.size();
        int index = 0;
        for (SingleInputGate inputGate : this.inputGates) {
            if (index++ < remainingQuota) {
                this.reservedPartitionRequestQuota.put(inputGate, averageQuota + 1);
                continue;
            }
            this.reservedPartitionRequestQuota.put(inputGate, averageQuota);
        }
    }

    private RemoteInputChannel getPendingRemoteChannel(SingleInputGate inputGate) {
        assert (Thread.holdsLock(this.lock));
        LinkedList<RemoteInputChannel> channelList = this.pendingPartitionRequests.get(inputGate);
        if (channelList == null) {
            return null;
        }
        RemoteInputChannel remoteInputChannel = channelList.pollFirst();
        if (channelList.isEmpty()) {
            this.pendingPartitionRequests.remove(inputGate);
        }
        return remoteInputChannel;
    }

    private void addPendingRemoteChannel(SingleInputGate inputGate, RemoteInputChannel inputChannel) {
        assert (Thread.holdsLock(this.lock));
        LinkedList<RemoteInputChannel> channelList = this.pendingPartitionRequests.get(inputGate);
        if (channelList == null) {
            channelList = new LinkedList();
            this.pendingPartitionRequests.put(inputGate, channelList);
        }
        channelList.addLast(inputChannel);
    }

    private void internalRequestSubpartition(SingleInputGate inputGate, InputChannel inputChannel, int consumedSubpartitionIndex) throws IOException, InterruptedException {
        if (inputChannel instanceof RemoteInputChannel) {
            inputGate.assignExclusiveSegments(inputChannel);
        }
        inputChannel.requestSubpartition(consumedSubpartitionIndex);
    }
}

