/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockShuffleUtils;
import org.apache.flink.runtime.io.network.partition.external.LocalResultPartitionResolver;
import org.apache.flink.runtime.io.network.partition.external.OsCachePolicy;
import org.apache.flink.runtime.io.network.partition.external.PartitionIndex;
import org.apache.flink.runtime.io.network.partition.external.PersistentFileType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExternalBlockResultPartitionMeta {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalBlockResultPartitionMeta.class);
    public static final int SUPPORTED_PROTOCOL_VERSION = 1;
    private final ResultPartitionID resultPartitionID;
    private final FileSystem fileSystem;
    private final OsCachePolicy osCachePolicy;
    private final long maxReadAheadLength;
    @GuardedBy(value="this")
    private volatile boolean hasInitialized = false;
    private PersistentFileType externalFileType = PersistentFileType.UNDEFINED;
    private List<ExternalSubpartitionMeta>[] subpartitionMetas;
    private final LocalResultPartitionResolver.ResultPartitionFileInfo fileInfo;
    private int spillCount = 1;
    private int subpartitionNum = 0;
    private final AtomicInteger unconsumedSubpartitionCount = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger refCount = new AtomicInteger(0);
    private final AtomicReference<Long> lastActiveTimeInMs = new AtomicReference<Long>(-1L);

    ExternalBlockResultPartitionMeta(ResultPartitionID resultPartitionID, FileSystem fileSystem, LocalResultPartitionResolver.ResultPartitionFileInfo fileInfo, OsCachePolicy osCachePolicy, long maxReadAheadLength) {
        this.resultPartitionID = resultPartitionID;
        this.fileSystem = fileSystem;
        this.fileInfo = fileInfo;
        this.osCachePolicy = osCachePolicy;
        this.maxReadAheadLength = maxReadAheadLength;
    }

    boolean hasInitialized() {
        return this.hasInitialized;
    }

    synchronized void initialize() throws IOException {
        if (this.hasInitialized) {
            return;
        }
        this.initializeByFinishFile();
        this.initializeByIndexFile();
        this.unconsumedSubpartitionCount.set(this.subpartitionNum);
        this.lastActiveTimeInMs.set(System.currentTimeMillis());
        this.hasInitialized = true;
    }

    public String getRootDir() {
        return this.fileInfo.getRootDir();
    }

    public String getResultPartitionDir() {
        return this.fileInfo.getPartitionDir();
    }

    public OsCachePolicy getOsCachePolicy() {
        return this.osCachePolicy;
    }

    public long getMaxReadAheadLength() {
        return this.maxReadAheadLength;
    }

    public synchronized List<ExternalSubpartitionMeta> getSubpartitionMeta(int subpartitionIndex) {
        Preconditions.checkState((boolean)this.hasInitialized, (Object)"The meta info has not been initialized.");
        Preconditions.checkArgument((subpartitionIndex >= 0 && subpartitionIndex < this.subpartitionNum ? 1 : 0) != 0, (Object)"Invalid subpartition index.");
        return this.subpartitionMetas[subpartitionIndex];
    }

    PersistentFileType getExternalBlockFileType() {
        if (this.hasInitialized()) {
            return this.externalFileType;
        }
        throw new RuntimeException("This method should be called after initialize()");
    }

    long getConsumedPartitionTTL() {
        return this.fileInfo.getConsumedPartitionTTL();
    }

    long getPartialConsumedPartitionTTL() {
        return this.fileInfo.getPartialConsumedPartitionTTL();
    }

    void notifySubpartitionStartConsuming(int subpartitionIndex) {
        this.lastActiveTimeInMs.set(System.currentTimeMillis());
        this.refCount.addAndGet(1);
    }

    void notifySubpartitionConsumed(int subpartitionIndex) {
        long currTime = System.currentTimeMillis();
        if (this.unconsumedSubpartitionCount.decrementAndGet() < 1 && LOG.isDebugEnabled()) {
            LOG.debug("Partition {} 's reference count turn to zero at {}", (Object)this.resultPartitionID, (Object)currTime);
        }
        this.lastActiveTimeInMs.set(currTime);
        this.refCount.decrementAndGet();
    }

    int getReferenceCount() {
        return this.refCount.get();
    }

    int getUnconsumedSubpartitionCount() {
        int count = this.unconsumedSubpartitionCount.get();
        return count >= 0 ? count : 0;
    }

    long getLastActiveTimeInMs() {
        return this.lastActiveTimeInMs.get();
    }

    @VisibleForTesting
    ResultPartitionID getResultPartitionID() {
        return this.resultPartitionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeByFinishFile() throws IOException {
        String finishedPathStr = ExternalBlockShuffleUtils.generateFinishedPath(this.fileInfo.getPartitionDir());
        Path finishFilePath = new Path(finishedPathStr);
        if (!this.fileSystem.exists(finishFilePath)) {
            throw new IOException("Finish file doesn't exist, file path: " + finishFilePath.getPath());
        }
        FSDataInputStream finishIn = null;
        try {
            finishIn = this.fileSystem.open(finishFilePath);
            if (null == finishIn) {
                throw new IOException("Cannot open finish file, file path: " + finishedPathStr);
            }
            DataInputViewStreamWrapper finishView = new DataInputViewStreamWrapper((InputStream)finishIn);
            int version = finishView.readInt();
            if (version > 1) {
                throw new RuntimeException("Unsupported External Data version: " + version + ", supported version: " + 1);
            }
            int typeLength = finishView.readInt();
            byte[] typeContent = new byte[typeLength];
            finishView.read(typeContent);
            this.externalFileType = PersistentFileType.valueOf(new String(typeContent));
            this.spillCount = finishView.readInt();
            if (this.externalFileType == PersistentFileType.HASH_PARTITION_FILE ? !$assertionsDisabled && this.spillCount != 1 : !$assertionsDisabled && this.spillCount < 0) {
                throw new AssertionError();
            }
            this.subpartitionNum = finishView.readInt();
            assert (this.subpartitionNum > 0);
        }
        finally {
            if (null != finishIn) {
                finishIn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeByIndexFile() throws IOException {
        PartitionIndex[][] partitionIndices = new PartitionIndex[this.spillCount][];
        Path[] dataFiles = new Path[this.spillCount];
        Path indexFilePath = null;
        DataInputViewStreamWrapper indexView = null;
        try (FSDataInputStream indexIn = null;){
            for (int idx = 0; idx < this.spillCount; ++idx) {
                PartitionIndex[] tmpPartitionIndexArr;
                if (indexIn != null) {
                    indexIn.close();
                    indexIn = null;
                }
                if (!this.fileSystem.exists(indexFilePath = new Path(ExternalBlockShuffleUtils.generateIndexPath(this.fileInfo.getPartitionDir(), idx)))) {
                    throw new IOException("Index file doesn't exist, file path: " + indexFilePath.getPath());
                }
                indexIn = this.fileSystem.open(indexFilePath);
                if (indexIn == null) {
                    throw new IOException("cannot open index file, file path: " + indexFilePath.getPath());
                }
                indexView = new DataInputViewStreamWrapper((InputStream)indexIn);
                if (this.externalFileType != PersistentFileType.HASH_PARTITION_FILE) {
                    dataFiles[idx] = new Path(ExternalBlockShuffleUtils.generateDataPath(this.fileInfo.getPartitionDir(), idx));
                }
                if (null == (tmpPartitionIndexArr = ExternalBlockShuffleUtils.deserializeIndices((DataInputView)indexView, this.subpartitionNum))) {
                    throw new IOException("cannot read index file, file path: " + indexFilePath.getPath());
                }
                partitionIndices[idx] = tmpPartitionIndexArr;
            }
        }
        this.subpartitionMetas = new ArrayList[this.subpartitionNum];
        for (int subpartitionIndex = 0; subpartitionIndex < this.subpartitionNum; ++subpartitionIndex) {
            ArrayList<ExternalSubpartitionMeta> subpartitionMeta = new ArrayList<ExternalSubpartitionMeta>();
            for (int spillIdx = 0; spillIdx < this.spillCount; ++spillIdx) {
                PartitionIndex partitionIndex = partitionIndices[spillIdx][subpartitionIndex];
                if (partitionIndex == null) continue;
                Path dataFile = this.externalFileType == PersistentFileType.HASH_PARTITION_FILE ? new Path(ExternalBlockShuffleUtils.generateDataPath(this.fileInfo.getPartitionDir(), subpartitionIndex)) : dataFiles[spillIdx];
                subpartitionMeta.add(new ExternalSubpartitionMeta(dataFile, partitionIndex.getStartOffset(), partitionIndex.getLength()));
            }
            this.subpartitionMetas[subpartitionIndex] = subpartitionMeta;
        }
    }

    private static String convertSubpartitionMetasToString(List<ExternalSubpartitionMeta> subpartitionMeta) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("subpartition metas' detail: {");
        for (ExternalSubpartitionMeta meta : subpartitionMeta) {
            stringBuilder.append(meta.toString());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    static final class ExternalSubpartitionMeta {
        private final Path dataFile;
        private final long offset;
        private final long length;

        ExternalSubpartitionMeta(Path dataFile, long offset, long length) {
            assert (dataFile != null);
            assert (offset >= 0L);
            assert (length >= 0L);
            this.dataFile = dataFile;
            this.offset = offset;
            this.length = length;
        }

        Path getDataFile() {
            return this.dataFile;
        }

        long getOffset() {
            return this.offset;
        }

        long getLength() {
            return this.length;
        }

        public String toString() {
            return "{ dataFilePath = " + this.dataFile + ", offset = " + this.offset + ", buffNum = " + this.length + " }";
        }
    }
}

