/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external;

import java.io.IOException;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.external.PartitionIndex;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalBlockShuffleUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalBlockShuffleUtils.class);
    private static final String CONFIG_FILE = "config";
    private static final String DATA_FILE = "data";
    private static final String SPILL_FILE = "spill";
    private static final String INDEX_FILE = "index";
    private static final String MERGE_FILE = "merge";
    private static final String FINISHED_FILE = "finished";
    private static final String PARTITION_DIR_PREFIX = "partition_";
    private static final String SPLITTER = "_";

    public static String generatePartitionRootPath(String prefix, String producerId, String partitionId) {
        return prefix + "/" + PARTITION_DIR_PREFIX + producerId + SPLITTER + partitionId + "/";
    }

    public static ResultPartitionID convertRelativeDirToResultPartitionID(String relativeDir) {
        if (!relativeDir.startsWith(PARTITION_DIR_PREFIX)) {
            return null;
        }
        String[] segments = relativeDir.substring(PARTITION_DIR_PREFIX.length()).split(SPLITTER);
        if (segments == null || segments.length != 2) {
            return null;
        }
        try {
            return new ResultPartitionID(new IntermediateResultPartitionID(DatatypeConverter.parseHexBinary((String)segments[1])), new ExecutionAttemptID(DatatypeConverter.parseHexBinary((String)segments[0])));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String generateDataPath(String partitionPrefix, int fileIndex) {
        return partitionPrefix + fileIndex + "." + DATA_FILE;
    }

    public static String generateSpillPath(String partitionPrefix, int fileIndex) {
        return partitionPrefix + fileIndex + "." + SPILL_FILE;
    }

    public static String generateMergePath(String partitionPrefix, int fileIndex) {
        return partitionPrefix + fileIndex + "." + MERGE_FILE;
    }

    public static String generateIndexPath(String partitionPrefix, int fileIndex) {
        return partitionPrefix + fileIndex + "." + INDEX_FILE;
    }

    public static String generateFinishedPath(String partitionPrefix) {
        return partitionPrefix + FINISHED_FILE;
    }

    public static String generateConfigPath(String partitionPrefix) {
        return partitionPrefix + CONFIG_FILE;
    }

    public static int hashPartitionToDisk(String producerId, String partitionId) {
        int hashCode2 = (producerId + partitionId).hashCode();
        hashCode2 = hashCode2 < 0 ? -hashCode2 : hashCode2;
        return hashCode2;
    }

    public static void serializeIndices(List<PartitionIndex> indices, DataOutputView out) throws IOException {
        Preconditions.checkNotNull(indices);
        out.writeInt(indices.size());
        for (PartitionIndex index : indices) {
            out.writeInt(index.getPartition());
            out.writeLong(index.getStartOffset());
            out.writeLong(index.getLength());
        }
    }

    public static PartitionIndex[] deserializeIndices(DataInputView in, int subpartitionNum) throws IOException {
        int size = in.readInt();
        if (subpartitionNum <= 0) {
            subpartitionNum = size;
        } else assert (subpartitionNum >= size);
        PartitionIndex[] indices = new PartitionIndex[subpartitionNum];
        for (int i = 0; i < size; ++i) {
            PartitionIndex index;
            int partitionId = in.readInt();
            indices[partitionId] = index = new PartitionIndex(partitionId, in.readLong(), in.readLong());
        }
        return indices;
    }
}

