/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockShuffleServiceOptions;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.slf4j.Logger;

public enum OsCachePolicy {
    NO_TREATMENT,
    READ_AHEAD,
    SEQUENTIAL,
    NO_REUSE;


    public String toString() {
        switch (this) {
            case READ_AHEAD: {
                return "read-ahead";
            }
            case SEQUENTIAL: {
                return "sequential";
            }
            case NO_REUSE: {
                return "no-reuse";
            }
        }
        return "no-treatment";
    }

    int getFadviceFlag() {
        switch (this) {
            case READ_AHEAD: {
                return 3;
            }
            case SEQUENTIAL: {
                return 2;
            }
            case NO_REUSE: {
                return 5;
            }
        }
        return 0;
    }

    static String getSupportedOsCachePolicies() {
        StringBuilder stringBuilder = new StringBuilder(45);
        for (OsCachePolicy policy : OsCachePolicy.values()) {
            stringBuilder.append(policy.toString()).append(",");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    static OsCachePolicy getOsCachePolicyFromConfiguration(Configuration configuration, Logger logger) {
        OsCachePolicy osCachePolicy = NO_TREATMENT;
        String strOsCachePolicy = configuration.getString(ExternalBlockShuffleServiceOptions.OS_CACHE_POLICY);
        for (OsCachePolicy policy : OsCachePolicy.values()) {
            if (!policy.toString().equals(strOsCachePolicy)) continue;
            osCachePolicy = policy;
        }
        if (!osCachePolicy.equals((Object)NO_TREATMENT) && !NativeIO.isAvailable()) {
            logger.warn("Current OS cache policy [" + (Object)((Object)osCachePolicy) + "] cannot take effect. Make sure the native-hadoop library is in the library path. Use no-treatment policy instead.");
            osCachePolicy = NO_TREATMENT;
        }
        return osCachePolicy;
    }
}

