/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external;

public class PartitionIndex {
    private final int partition;
    private final long startOffset;
    private final long length;
    private final transient long numRecords;

    public PartitionIndex(int partition, long startOffset, long length) {
        this(partition, startOffset, length, 0L);
    }

    public PartitionIndex(int partition, long startOffset, long length, long numRecords) {
        this.partition = partition;
        this.startOffset = startOffset;
        this.length = length;
        this.numRecords = numRecords;
    }

    public int getPartition() {
        return this.partition;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getLength() {
        return this.length;
    }

    public long getNumRecords() {
        return this.numRecords;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionIndex that = (PartitionIndex)o;
        return this.partition == that.partition && this.startOffset == that.startOffset && this.length == that.length && this.numRecords == that.numRecords;
    }

    public int hashCode() {
        int result = this.partition;
        result = 31 * result + (int)(this.startOffset ^ this.startOffset >>> 32);
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + (int)(this.numRecords ^ this.numRecords >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PartitionIndex :{ partition=").append(this.partition).append(", startOffset=").append(this.startOffset).append(", length=").append(this.length).append(", numRecords=").append(this.numRecords).append("}");
        return stringBuilder.toString();
    }
}

