/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external.writer;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.api.serialization.SerializerManager;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockShuffleUtils;
import org.apache.flink.runtime.io.network.partition.external.writer.BufferSortedDataFile;
import org.apache.flink.runtime.operators.sort.SortedDataFile;
import org.apache.flink.runtime.operators.sort.SortedDataFileFactory;
import org.apache.flink.runtime.plugable.SerializationDelegate;

public class BufferSortedDataFileFactory<T>
implements SortedDataFileFactory<T> {
    private final String partitionDataRootPath;
    private final TypeSerializer<T> serialize;
    private final IOManager ioManager;
    private final SerializerManager<SerializationDelegate<T>> serializerManager;
    private final Counter numBytesOut;
    private final Counter numBuffersOut;
    private int nextFileId;

    public BufferSortedDataFileFactory(String partitionDataRootPath, TypeSerializer<T> serialize, IOManager ioManager, SerializerManager<SerializationDelegate<T>> serializerManager, Counter numBytesOut, Counter numBuffersOut) {
        this.partitionDataRootPath = partitionDataRootPath;
        this.serialize = serialize;
        this.ioManager = ioManager;
        this.serializerManager = serializerManager;
        this.numBytesOut = numBytesOut;
        this.numBuffersOut = numBuffersOut;
    }

    @Override
    public SortedDataFile<T> createFile(List<MemorySegment> writeMemory) throws IOException {
        int fileId = this.nextFileId++;
        String path = ExternalBlockShuffleUtils.generateSpillPath(this.partitionDataRootPath, fileId);
        return new BufferSortedDataFile<T>(this.ioManager.createChannel(new File(path)), fileId, this.serialize, this.ioManager, writeMemory, this.serializerManager, this.numBytesOut, this.numBuffersOut);
    }
}

