/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external.writer;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.io.network.partition.external.PartitionIndex;

public class PartitionIndexGenerator {
    private final int numberOfPartitions;
    private final List<PartitionIndex> partitionIndices;
    private long lastRecordsWritten = 0L;
    private int currentPartition = 0;
    private long currentPartitionStartOffset = 0L;

    public PartitionIndexGenerator(int numberOfPartitions) {
        this.numberOfPartitions = numberOfPartitions;
        this.partitionIndices = new ArrayList<PartitionIndex>(numberOfPartitions);
    }

    public void updatePartitionIndexBeforeWriting(int partition, long numBytesWrittenBeforeWriting, long numRecordsWrittenBeforeWriting) {
        if (partition != this.currentPartition) {
            PartitionIndex partitionIndex = new PartitionIndex(this.currentPartition, this.currentPartitionStartOffset, numBytesWrittenBeforeWriting - this.currentPartitionStartOffset, numRecordsWrittenBeforeWriting - this.lastRecordsWritten);
            this.partitionIndices.add(partitionIndex);
            for (int i = this.currentPartition + 1; i < partition; ++i) {
                this.partitionIndices.add(new PartitionIndex(i, numBytesWrittenBeforeWriting, 0L, 0L));
            }
            this.lastRecordsWritten = numRecordsWrittenBeforeWriting;
            this.currentPartition = partition;
            this.currentPartitionStartOffset = numBytesWrittenBeforeWriting;
        }
    }

    public void finishWriting(long numBytesWrittenBefore, long numRecordsWrittenBefore) {
        PartitionIndex partitionIndex = new PartitionIndex(this.currentPartition, this.currentPartitionStartOffset, numBytesWrittenBefore - this.currentPartitionStartOffset, numRecordsWrittenBefore - this.lastRecordsWritten);
        this.partitionIndices.add(partitionIndex);
        for (int i = this.currentPartition + 1; i < this.numberOfPartitions; ++i) {
            this.partitionIndices.add(new PartitionIndex(i, numBytesWrittenBefore, 0L, 0L));
        }
    }

    public List<PartitionIndex> getPartitionIndices() {
        return this.partitionIndices;
    }
}

