/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.flink.runtime.jobgraph.FormatUtil;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.util.TaskConfig;

public class InputFormatVertex
extends JobVertex {
    private static final long serialVersionUID = 1L;
    private String formatDescription;
    private OperatorID sourceOperatorId;

    public InputFormatVertex(String name) {
        this(name, (OperatorID)null);
    }

    public InputFormatVertex(String name, @Nullable OperatorID sourceOperatorId) {
        super(name);
        this.sourceOperatorId = sourceOperatorId != null ? sourceOperatorId : OperatorID.fromJobVertexID(this.getID());
    }

    public void setFormatDescription(String formatDescription) {
        this.formatDescription = formatDescription;
    }

    public String getFormatDescription() {
        return this.formatDescription;
    }

    @Override
    public void initializeOnMaster(ClassLoader loader) throws Exception {
        TaskConfig cfg = new TaskConfig(this.getConfiguration());
        FormatUtil.InputFormatStub stub = new FormatUtil.InputFormatStub(cfg, loader, this.sourceOperatorId);
        FormatUtil.initializeInputFormatsOnMaster(this, stub, Collections.singletonMap(this.sourceOperatorId, this.formatDescription));
    }
}

