/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.operators.ResourceConstraints;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.InputSplitSource;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.ControlType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobControlEdge;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorDescriptor;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobgraph.tasks.StoppableTask;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.resourcemanager.placementconstraint.SlotTag;
import org.apache.flink.util.Preconditions;

public class JobVertex
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_NAME = "(unnamed vertex)";
    private final JobVertexID id;
    private final ArrayList<JobVertexID> idAlternatives = new ArrayList();
    private final ArrayList<OperatorID> operatorIDs = new ArrayList();
    private final ArrayList<OperatorID> operatorIdsAlternatives = new ArrayList();
    private final ArrayList<OperatorDescriptor> operatorDescriptors = new ArrayList();
    private final ArrayList<IntermediateDataSet> results = new ArrayList();
    private final ArrayList<JobEdge> inputs = new ArrayList();
    private final ArrayList<JobControlEdge> inControlEdges = new ArrayList();
    private final ArrayList<JobControlEdge> outControlEdges = new ArrayList();
    private int parallelism = -1;
    private int maxParallelism = -1;
    private ResourceSpec minResources = ResourceSpec.DEFAULT;
    private ResourceSpec preferredResources = ResourceSpec.DEFAULT;
    private ResourceConstraints resourceConstraints = null;
    private Configuration configuration;
    private String invokableClassName;
    private boolean isStoppable = false;
    private Map<OperatorID, InputSplitSource<?>> inputSplitSourceMap;
    private String name;
    private SlotSharingGroup slotSharingGroup;
    private CoLocationGroup coLocationGroup;
    private String operatorName;
    private String operatorDescription;
    private String operatorPrettyName;
    private String resultOptimizerProperties;
    private List<SlotTag> tags = new ArrayList<SlotTag>();

    public JobVertex(String name) {
        this(name, null);
    }

    public JobVertex(String name, JobVertexID id) {
        this.name = name == null ? DEFAULT_NAME : name;
        this.id = id == null ? new JobVertexID() : id;
        this.operatorIDs.add(OperatorID.fromJobVertexID(this.id));
        this.operatorIdsAlternatives.add(null);
    }

    public JobVertex(String name, JobVertexID primaryId, List<JobVertexID> alternativeIds, List<OperatorID> operatorIds, List<OperatorID> alternativeOperatorIds) {
        Preconditions.checkArgument((operatorIds.size() == alternativeOperatorIds.size() ? 1 : 0) != 0);
        this.name = name == null ? DEFAULT_NAME : name;
        this.id = primaryId == null ? new JobVertexID() : primaryId;
        this.idAlternatives.addAll(alternativeIds);
        this.operatorIDs.addAll(operatorIds);
        this.operatorIdsAlternatives.addAll(alternativeOperatorIds);
    }

    public JobVertexID getID() {
        return this.id;
    }

    public List<JobVertexID> getIdAlternatives() {
        return this.idAlternatives;
    }

    public List<OperatorDescriptor> getOperatorDescriptors() {
        return this.operatorDescriptors;
    }

    public void addOperatorDescriptor(OperatorDescriptor operatorDescriptor) {
        this.operatorDescriptors.add(operatorDescriptor);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? DEFAULT_NAME : name;
    }

    public int getNumberOfProducedIntermediateDataSets() {
        return this.results.size();
    }

    public int getNumberOfInputs() {
        return this.inputs.size();
    }

    public List<OperatorID> getOperatorIDs() {
        return this.operatorIDs;
    }

    public List<OperatorID> getUserDefinedOperatorIDs() {
        return this.operatorIdsAlternatives;
    }

    public void addTag(SlotTag tag) {
        this.tags.add(tag);
    }

    public List<SlotTag> getTags() {
        return this.tags;
    }

    public Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Configuration();
        }
        return this.configuration;
    }

    public void setInvokableClass(Class<? extends AbstractInvokable> invokable) {
        Preconditions.checkNotNull(invokable);
        this.invokableClassName = invokable.getName();
        this.isStoppable = StoppableTask.class.isAssignableFrom(invokable);
    }

    public String getInvokableClassName() {
        return this.invokableClassName;
    }

    public Class<? extends AbstractInvokable> getInvokableClass(ClassLoader cl) {
        if (cl == null) {
            throw new NullPointerException("The classloader must not be null.");
        }
        if (this.invokableClassName == null) {
            return null;
        }
        try {
            return Class.forName(this.invokableClassName, true, cl).asSubclass(AbstractInvokable.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("The user-code class could not be resolved.", e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("The user-code class is no subclass of " + AbstractInvokable.class.getName(), e);
        }
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        if (parallelism < 1) {
            throw new IllegalArgumentException("The parallelism must be at least one.");
        }
        this.parallelism = parallelism;
        for (JobEdge edge : this.getInputs()) {
            edge.clearConsumerExecutionVerticesCache();
        }
        for (IntermediateDataSet dataSet : this.getProducedDataSets()) {
            for (JobEdge edge : dataSet.getConsumers()) {
                edge.clearConsumerExecutionVerticesCache();
            }
        }
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public void setMaxParallelism(int maxParallelism) {
        this.maxParallelism = maxParallelism;
    }

    public ResourceSpec getMinResources() {
        return this.minResources;
    }

    public ResourceSpec getPreferredResources() {
        return this.preferredResources;
    }

    public void setResources(ResourceSpec minResources, ResourceSpec preferredResources) {
        this.minResources = (ResourceSpec)Preconditions.checkNotNull((Object)minResources);
        this.preferredResources = (ResourceSpec)Preconditions.checkNotNull((Object)preferredResources);
    }

    public ResourceConstraints getResourceConstraints() {
        return this.resourceConstraints;
    }

    public void setResourceConstraints(ResourceConstraints resourceConstraints) {
        this.resourceConstraints = resourceConstraints;
    }

    public Map<OperatorID, InputSplitSource<?>> getInputSplitSources() {
        return this.inputSplitSourceMap;
    }

    public void setInputSplitSource(OperatorID operatorID, InputSplitSource<?> inputSplitSource) {
        if (this.inputSplitSourceMap == null) {
            this.inputSplitSourceMap = new HashMap();
        }
        this.inputSplitSourceMap.put(operatorID, inputSplitSource);
    }

    public List<IntermediateDataSet> getProducedDataSets() {
        return this.results;
    }

    public List<JobEdge> getInputs() {
        return this.inputs;
    }

    public List<JobControlEdge> getInControlEdges() {
        return this.inControlEdges;
    }

    public List<JobControlEdge> getOutControlEdges() {
        return this.outControlEdges;
    }

    public void setSlotSharingGroup(SlotSharingGroup grp) {
        if (this.slotSharingGroup != null) {
            this.slotSharingGroup.removeVertexFromGroup(this.id);
        }
        this.slotSharingGroup = grp;
        if (grp != null) {
            grp.addVertexToGroup(this.id);
            grp.addTagsToGroup(this.tags);
        }
    }

    public SlotSharingGroup getSlotSharingGroup() {
        return this.slotSharingGroup;
    }

    public void setStrictlyCoLocatedWith(JobVertex strictlyCoLocatedWith) {
        if (this.slotSharingGroup == null || this.slotSharingGroup != strictlyCoLocatedWith.slotSharingGroup) {
            throw new IllegalArgumentException("Strict co-location requires that both vertices are in the same slot sharing group.");
        }
        CoLocationGroup thisGroup = this.coLocationGroup;
        CoLocationGroup otherGroup = strictlyCoLocatedWith.coLocationGroup;
        if (otherGroup == null) {
            if (thisGroup == null) {
                CoLocationGroup group;
                this.coLocationGroup = group = new CoLocationGroup(this, strictlyCoLocatedWith);
                strictlyCoLocatedWith.coLocationGroup = group;
            } else {
                thisGroup.addVertex(strictlyCoLocatedWith);
                strictlyCoLocatedWith.coLocationGroup = thisGroup;
            }
        } else if (thisGroup == null) {
            otherGroup.addVertex(this);
            this.coLocationGroup = otherGroup;
        } else {
            thisGroup.mergeInto(otherGroup);
        }
    }

    public CoLocationGroup getCoLocationGroup() {
        return this.coLocationGroup;
    }

    public void updateCoLocationGroup(CoLocationGroup group) {
        this.coLocationGroup = group;
    }

    @VisibleForTesting
    public IntermediateDataSet createAndAddResultDataSet(ResultPartitionType partitionType) {
        return this.createAndAddResultDataSet(new IntermediateDataSetID(), partitionType);
    }

    public IntermediateDataSet createAndAddResultDataSet(IntermediateDataSetID id, ResultPartitionType partitionType) {
        IntermediateDataSet result = new IntermediateDataSet(id, partitionType, this);
        this.results.add(result);
        return result;
    }

    @VisibleForTesting
    public JobEdge connectDataSetAsInput(IntermediateDataSet dataSet, DistributionPattern distPattern) {
        JobEdge edge = new JobEdge(dataSet, this, distPattern);
        this.inputs.add(edge);
        dataSet.addConsumer(edge);
        return edge;
    }

    public JobEdge connectNewDataSetAsInput(JobVertex input, DistributionPattern distPattern, ResultPartitionType partitionType) {
        return this.connectDataSetAsInput(input, new IntermediateDataSetID(), distPattern, partitionType);
    }

    public JobEdge connectDataSetAsInput(JobVertex input, IntermediateDataSetID dataSetID, DistributionPattern distPattern, ResultPartitionType partitionType) {
        IntermediateDataSet dataSet = input.createAndAddResultDataSet(dataSetID, partitionType);
        JobEdge edge = new JobEdge(dataSet, this, distPattern);
        this.inputs.add(edge);
        dataSet.addConsumer(edge);
        return edge;
    }

    @VisibleForTesting
    public void connectIdInput(IntermediateDataSetID dataSetId, DistributionPattern distPattern) {
        JobEdge edge = new JobEdge(dataSetId, this, distPattern);
        this.inputs.add(edge);
    }

    public JobControlEdge connectControlEdge(JobVertex sourceVertex, ControlType controlType) {
        JobControlEdge controlEdge = new JobControlEdge(sourceVertex, this, controlType);
        sourceVertex.outControlEdges.add(controlEdge);
        this.inControlEdges.add(controlEdge);
        return controlEdge;
    }

    public boolean isInputVertex() {
        return this.inputs.isEmpty();
    }

    public boolean isStoppable() {
        return this.isStoppable;
    }

    public boolean isOutputVertex() {
        return this.results.isEmpty();
    }

    public boolean hasNoConnectedInputs() {
        for (JobEdge edge : this.inputs) {
            if (edge.isIdReference()) continue;
            return false;
        }
        return true;
    }

    public void initializeOnMaster(ClassLoader loader) throws Exception {
    }

    public void finalizeOnMaster(ClassLoader loader) throws Exception {
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getOperatorDescription() {
        return this.operatorDescription;
    }

    public void setOperatorDescription(String operatorDescription) {
        this.operatorDescription = operatorDescription;
    }

    public void setOperatorPrettyName(String operatorPrettyName) {
        this.operatorPrettyName = operatorPrettyName;
    }

    public String getOperatorPrettyName() {
        return this.operatorPrettyName;
    }

    public String getResultOptimizerProperties() {
        return this.resultOptimizerProperties;
    }

    public void setResultOptimizerProperties(String resultOptimizerProperties) {
        this.resultOptimizerProperties = resultOptimizerProperties;
    }

    public String toString() {
        return this.name + " (" + this.invokableClassName + ')';
    }
}

