/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.flink.runtime.jobgraph.OperatorEdgeDescriptor;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.metrics.dump.MetricQueryService;
import org.apache.flink.util.Preconditions;

public class OperatorDescriptor
implements Serializable {
    private final String operatorName;
    private final OperatorID operatorID;
    private final String operatorMetricsName;
    private final Integer nodeId;
    private final List<OperatorEdgeDescriptor> inputs = new ArrayList<OperatorEdgeDescriptor>();

    public OperatorDescriptor(String operatorName, OperatorID operatorID, Integer nodeId) {
        this.operatorName = (String)Preconditions.checkNotNull((Object)operatorName);
        this.operatorID = (OperatorID)((Object)Preconditions.checkNotNull((Object)((Object)operatorID)));
        this.operatorMetricsName = this.name2MetricName(operatorName);
        this.nodeId = (Integer)Preconditions.checkNotNull((Object)nodeId);
    }

    private String name2MetricName(String name) {
        String metricName = name;
        if (name != null && name.length() > 80) {
            metricName = name.substring(0, 80);
        }
        metricName = MetricQueryService.FILTER.filterCharacters(metricName);
        return metricName;
    }

    public void addInput(OperatorEdgeDescriptor operatorEdgeDescriptor) {
        this.inputs.add(operatorEdgeDescriptor);
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public OperatorID getOperatorID() {
        return this.operatorID;
    }

    public String getOperatorMetricsName() {
        return this.operatorMetricsName;
    }

    public List<OperatorEdgeDescriptor> getInputs() {
        return this.inputs;
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("operatorName", (Object)this.operatorName).append("operatorID", (Object)this.operatorID).append("inputs", this.inputs).append("metricName", (Object)this.operatorMetricsName).append("nodeId", (Object)this.nodeId).toString();
    }
}

